/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.panels.project;

import com.japisoft.editix.project.ProjectListener;
import com.japisoft.editix.project.ProjectManager;
import com.japisoft.editix.ui.panels.AbstractPanel;
import com.japisoft.editix.ui.panels.project.ProjectUI;
import com.japisoft.framework.application.descriptor.ActionModel;
import com.japisoft.framework.preferences.Preferences;
import javax.swing.JComponent;

public class ProjectPanel
extends AbstractPanel
implements ProjectListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        String string;
        super.init();
        ProjectManager.setProjectListener(this);
        if (ProjectUI.isLocked() && (string = Preferences.getPreference(Preferences.SYSTEM_GP, "project.lastFile", (String)null)) != null) {
            ProjectListener projectListener = ProjectManager.getProjectListener();
            ProjectManager.setProjectListener(null);
            try {
                ProjectManager.openProject(string);
            }
            finally {
                ProjectManager.setProjectListener(projectListener);
            }
        }
        ((ProjectUI)this.getView()).init();
    }

    protected String getTitle() {
        return "Project";
    }

    protected JComponent buildView() {
        return new ProjectUI();
    }

    public void loadProject(String string) {
        ((ProjectUI)this.getView()).loadProject(string);
        this.show();
        this.setState(true);
    }

    public void clean() {
        ((ProjectUI)this.getView()).clean();
    }

    public void showPanel() {
        super.showPanel();
        ProjectManager.initProjectActions(true);
        ((ProjectUI)this.getView()).setEnabledAction("check", true);
        ((ProjectUI)this.getView()).setEnabledAction("zip", true);
        ActionModel.setEnabled("prjSaveAs", true);
        ActionModel.setEnabled("prjSave", true);
        ((ProjectUI)this.getView()).init();
    }

    public void refresh() {
        ((ProjectUI)this.getView()).refresh();
    }

    public void stop() {
        Preferences.setPreference(Preferences.SYSTEM_GP, "project.lastFile", ProjectManager.getLastOpenProject(true));
        ProjectManager.saveProject(ProjectManager.getLastOpenProject(true));
    }

    protected void preHide() {
        for (int i = 0; i < ProjectUI.POPUP_ACTIONS.length; ++i) {
            if (ProjectUI.POPUP_ACTIONS[i] == null) continue;
            ActionModel.setEnabled("prj." + ProjectUI.POPUP_ACTIONS[i], false);
        }
        ActionModel.setEnabled("prjSaveAs", false);
        ActionModel.setEnabled("prjSave", false);
    }
}

