/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.panels.diff;

import com.japisoft.editix.EditixApplicationModel;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.editix.ui.panels.diff.CustomTreeRenderer;
import com.japisoft.editix.ui.panels.diff.DiffResourceFactory;
import com.japisoft.editix.ui.pathbuilder.XMLPathBuilder;
import com.japisoft.fastparser.FastVector;
import com.japisoft.fastparser.Parser;
import com.japisoft.fastparser.document.Document;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.fastparser.swing.SwingNodeFactory;
import com.japisoft.framework.application.descriptor.ActionModel;
import com.japisoft.framework.ui.FastLabel;
import com.japisoft.framework.ui.text.FileTextField;
import com.japisoft.framework.ui.text.PathBuilder;
import com.japisoft.framework.xml.XMLFileData;
import com.japisoft.framework.xml.XMLToolkit;
import com.japisoft.xmlpad.IXMLPanel;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.tree.renderer.FastTreeRenderer;
import com.topologi.diffx.DiffXException;
import com.topologi.diffx.Main;
import com.topologi.diffx.config.DiffXConfig;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.layout.GroupLayout;

public class DiffPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    private JButton btReportFile = new JButton(new ImageIcon(ClassLoader.getSystemClassLoader().getResource("images/briefcase2_document.png")));
    private JButton btReportEdit = new JButton(new ImageIcon(ClassLoader.getSystemClassLoader().getResource("images/briefcase2_view.png")));
    private JButton btRefresh = new JButton(new ImageIcon(ClassLoader.getSystemClassLoader().getResource("images/refresh.png")));
    private JButton btAdded = new JButton(DiffResourceFactory.getIconForType(0));
    private JButton btDelete = new JButton(DiffResourceFactory.getIconForType(1));
    private JButton btAtt = new JButton(DiffResourceFactory.getIconForType(2));
    private boolean leftUpdated = false;
    private boolean rightUpdated = false;
    private DiffThread dt = null;
    private JPanel bottomPanel;
    private JToolBar bottomToolbar;
    private FileTextField cbLeft;
    private FileTextField cbRight;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JPanel panelTop;
    private JPanel panelTopLeft;
    private JPanel panelTopRight;
    private JScrollPane spBottom;
    private JScrollPane spLeft;
    private JScrollPane spRight;
    private JTable tbBottom;
    private JTree leftTree = new JTree(new DefaultMutableTreeNode("No document"));
    private JTree rightTree;
    private JLabel message;

    public DiffPanel(XMLContainer xMLContainer) {
        this.leftTree.setCellRenderer(new CustomTreeRenderer());
        this.rightTree = new JTree(new DefaultMutableTreeNode("No document"));
        this.rightTree.setCellRenderer(new FastTreeRenderer(null));
        this.initComponents();
        if (xMLContainer != null && xMLContainer.getCurrentDocumentLocation() != null) {
            this.cbLeft.setText(xMLContainer.getCurrentDocumentLocation());
            this.updateTree(this.cbLeft, this.leftTree);
        }
        this.jSplitPane1.setDividerLocation(200);
        this.tbBottom.getSelectionModel().setSelectionMode(0);
        this.bottomToolbar.add(this.btReportFile);
        this.bottomToolbar.add(this.btReportEdit);
        this.btReportFile.setToolTipText("Save a reporting file");
        this.btReportEdit.setToolTipText("Edit a reporting file");
        this.btRefresh.setToolTipText("Update the diff operation");
        this.btAdded.setToolTipText("Filter on added parts");
        this.btDelete.setToolTipText("Filter on deleted parts");
        this.btAtt.setToolTipText("Filter on attributes changing");
        this.bottomToolbar.addSeparator();
        this.bottomToolbar.add(this.btRefresh);
        this.bottomToolbar.addSeparator();
        this.bottomToolbar.add(this.btAdded);
        this.bottomToolbar.add(this.btDelete);
        this.bottomToolbar.add(this.btAtt);
        this.btReportFile.setEnabled(false);
        this.btReportEdit.setEnabled(false);
        this.btRefresh.setEnabled(false);
        this.btAdded.setEnabled(false);
        this.btDelete.setEnabled(false);
        this.btAtt.setEnabled(false);
        this.message = new JLabel();
        this.message.setPreferredSize(new Dimension(100, 0));
        this.bottomToolbar.add(this.message);
    }

    public void addNotify() {
        super.addNotify();
        this.cbLeft.setActionListener(this);
        this.cbRight.setActionListener(this);
        this.tbBottom.getSelectionModel().addListSelectionListener(this);
        this.btReportFile.addActionListener(this);
        this.btReportEdit.addActionListener(this);
        this.btRefresh.addActionListener(this);
        this.btAdded.addActionListener(this);
        this.btDelete.addActionListener(this);
        this.btAtt.addActionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.cbLeft.setActionListener(null);
        this.cbRight.setActionListener(null);
        this.tbBottom.getSelectionModel().removeListSelectionListener(null);
        this.btReportFile.removeActionListener(this);
        this.btReportEdit.removeActionListener(this);
        this.btRefresh.removeActionListener(this);
        this.btAdded.removeActionListener(this);
        this.btDelete.removeActionListener(this);
        this.btAtt.removeActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cbLeft) {
            this.updateTree(this.cbLeft, this.leftTree);
        } else if (actionEvent.getSource() == this.cbRight) {
            this.updateTree(this.cbRight, this.rightTree);
        } else if (actionEvent.getSource() == this.btReportEdit) {
            String string = ((CustomTreeModel)this.leftTree.getModel()).getSource();
            String string2 = ((CustomTreeModel)this.rightTree.getModel()).getSource();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                DiffXConfig diffXConfig = new DiffXConfig();
                diffXConfig.setIgnoreWhiteSpace(true);
                diffXConfig.setNamespaceAware(false);
                Main.diff((String)string, (String)string2, (OutputStream)byteArrayOutputStream, (DiffXConfig)diffXConfig);
                IXMLPanel iXMLPanel = EditixFactory.buildNewContainer();
                iXMLPanel.getMainContainer().setText(byteArrayOutputStream.toString());
                EditixFrame.ACCESSOR.addContainer(iXMLPanel);
                ActionModel.activeActionById("format", actionEvent, "silence");
                ActionModel.restoreAction("format").putValue("param", null);
            }
            catch (Exception exception) {}
        } else if (actionEvent.getSource() == this.btReportFile) {
            String string = ((CustomTreeModel)this.leftTree.getModel()).getSource();
            String string3 = ((CustomTreeModel)this.rightTree.getModel()).getSource();
            JFileChooser jFileChooser = EditixFactory.buildFileChooserForDocumentType("XML");
            if (jFileChooser.showSaveDialog(EditixFrame.ACCESSOR) == 0) {
                String string4 = jFileChooser.getSelectedFile().toString();
                if (string4.indexOf(".") == -1) {
                    string4 = string4 + ".xml";
                }
                try {
                    DiffXConfig diffXConfig = new DiffXConfig();
                    diffXConfig.setIgnoreWhiteSpace(true);
                    diffXConfig.setNamespaceAware(false);
                    Main.diff((String)string, (String)string3, (OutputStream)new FileOutputStream(string4), (DiffXConfig)diffXConfig);
                }
                catch (Exception exception) {
                    EditixFactory.buildAndShowErrorDialog("Can't save file " + jFileChooser.getSelectedFile());
                }
            }
        } else if (actionEvent.getSource() == this.btRefresh) {
            this.runDiff();
        } else if (actionEvent.getSource() == this.btAdded) {
            this.runDiff(0);
        } else if (actionEvent.getSource() == this.btDelete) {
            this.runDiff(1);
        } else if (actionEvent.getSource() == this.btAtt) {
            this.runDiff(2);
        }
    }

    private void updateTree(FileTextField fileTextField, JTree jTree) {
        String string = fileTextField.getText();
        this.updateTree(string, jTree);
    }

    private void updateTree(String string, JTree jTree) {
        Parser parser = new Parser();
        parser.setNodeFactory(new SwingNodeFactory());
        try {
            XMLFileData xMLFileData = XMLToolkit.getContentFromURI(string, null);
            parser.setText(xMLFileData.getContent());
            parser.parse();
            Document document = parser.getDocument();
            jTree.setModel(new CustomTreeModel(string, (TreeNode)((Object)document.getRoot())));
            if (jTree == this.leftTree) {
                this.leftUpdated = true;
            } else {
                this.rightUpdated = true;
            }
            if (this.leftUpdated && this.rightUpdated) {
                this.runDiff();
            }
        }
        catch (Throwable throwable) {
            EditixFactory.buildAndShowErrorDialog("Can't load " + string + " : " + throwable.getMessage());
        }
    }

    private void runDiff() {
        this.runDiff(-1);
    }

    private void runDiff(int n) {
        if (this.dt != null) {
            EditixFactory.buildAndShowWarningDialog("A Diff task is running, please wait before asking");
        } else {
            this.dt = new DiffThread(n);
            this.dt.start();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.tbBottom.getSelectedRow();
        if (n != -1) {
            ArrayList<SimpleNode> arrayList = new ArrayList<SimpleNode>();
            for (SimpleNode simpleNode = (SimpleNode)this.tbBottom.getModel().getValueAt(n, 1); simpleNode != null; simpleNode = simpleNode.getSimpleParent()) {
                arrayList.add(simpleNode);
            }
            Collections.reverse(arrayList);
            TreePath treePath = new TreePath(arrayList.toArray());
            this.leftTree.setSelectionPath(treePath);
            this.leftTree.scrollPathToVisible(treePath);
        }
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.panelTop = new JPanel();
        this.jSplitPane2 = new JSplitPane();
        this.panelTopLeft = new JPanel();
        this.cbLeft = new FileTextField(null, null, new String[]{"xml"}, (PathBuilder)new XMLPathBuilder());
        this.spLeft = new JScrollPane(this.leftTree);
        this.panelTopRight = new JPanel();
        this.cbRight = new FileTextField(null, null, new String[]{"xml"}, (PathBuilder)new XMLPathBuilder());
        this.spRight = new JScrollPane(this.rightTree);
        this.bottomPanel = new JPanel();
        this.bottomToolbar = new JToolBar();
        this.spBottom = new JScrollPane();
        this.tbBottom = new JTable(){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jSplitPane2.setDividerLocation(300);
        this.jSplitPane2.setOneTouchExpandable(true);
        this.panelTopLeft.setBorder(BorderFactory.createTitledBorder("Current Source"));
        GroupLayout groupLayout = new GroupLayout((Container)this.panelTopLeft);
        this.panelTopLeft.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.cbLeft, 0, 283, Short.MAX_VALUE).add((Component)this.spLeft, -1, 283, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.cbLeft, -2, -1, -2).addPreferredGap(0).add((Component)this.spLeft, -1, 289, Short.MAX_VALUE)));
        this.jSplitPane2.setLeftComponent(this.panelTopLeft);
        this.panelTopRight.setBorder(BorderFactory.createTitledBorder("Custom Source"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.panelTopRight);
        this.panelTopRight.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.cbRight, 0, 274, Short.MAX_VALUE).add((Component)this.spRight, -1, 274, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.cbRight, -2, -1, -2).addPreferredGap(0).add((Component)this.spRight, -1, 289, Short.MAX_VALUE)));
        this.jSplitPane2.setRightComponent(this.panelTopRight);
        GroupLayout groupLayout3 = new GroupLayout((Container)this.panelTop);
        this.panelTop.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.jSplitPane2, -1, 596, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.jSplitPane2, -1, 349, Short.MAX_VALUE));
        this.jSplitPane1.setTopComponent(this.panelTop);
        this.bottomToolbar.setFloatable(false);
        this.tbBottom.setModel(new DefaultTableModel(new String[]{"Type", "Diff"}, 0));
        this.spBottom.setViewportView(this.tbBottom);
        GroupLayout groupLayout4 = new GroupLayout((Container)this.bottomPanel);
        this.bottomPanel.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((Component)this.bottomToolbar, -1, 596, Short.MAX_VALUE).add(2, (Component)this.spBottom, -1, 596, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)this.bottomToolbar, -2, 25, -2).addPreferredGap(0).add((Component)this.spBottom, -1, 100, Short.MAX_VALUE).add(0, 0, 0)));
        this.jSplitPane1.setRightComponent(this.bottomPanel);
        GroupLayout groupLayout5 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout5);
        groupLayout5.setHorizontalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((Component)this.jSplitPane1, -1, 598, Short.MAX_VALUE).addContainerGap()));
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((Component)this.jSplitPane1, -1, 475, Short.MAX_VALUE).addContainerGap()));
    }

    class CustomMsgRenderer
    extends FastLabel
    implements TableCellRenderer {
        CustomMsgRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            SimpleNode simpleNode = (SimpleNode)object;
            this.setText((String)simpleNode.getApplicationObject());
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setForeground(Color.BLACK);
                Integer n3 = (Integer)jTable.getModel().getValueAt(n, 0);
                this.setBackground(DiffResourceFactory.getBgColorForType(n3));
            }
            return this;
        }
    }

    class CustomTypeRenderer
    extends FastLabel
    implements TableCellRenderer {
        CustomTypeRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Integer n3 = (Integer)object;
            this.setIcon(DiffResourceFactory.getIconForType(n3));
            return this;
        }
    }

    class CustomTreeModel
    extends DefaultTreeModel {
        private String source;

        public CustomTreeModel(String string, TreeNode treeNode) {
            super(treeNode);
            this.source = string;
        }

        public String getSource() {
            return this.source;
        }
    }

    class DiffThread
    extends Thread {
        private int filterType;

        DiffThread(int n) {
            this.filterType = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DiffPanel.this.message.setText("  Diff working, please wait...");
            try {
                this.runProxy();
            }
            finally {
                DiffPanel.this.message.setText(null);
            }
        }

        public void runProxy() {
            String string = ((CustomTreeModel)DiffPanel.this.leftTree.getModel()).getSource();
            String string2 = ((CustomTreeModel)DiffPanel.this.rightTree.getModel()).getSource();
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DiffXConfig diffXConfig = new DiffXConfig();
                diffXConfig.setNamespaceAware(false);
                diffXConfig.setIgnoreWhiteSpace(true);
                Main.diff((String)string, (String)string2, (OutputStream)byteArrayOutputStream, (DiffXConfig)diffXConfig);
                Parser parser = new Parser();
                parser.setInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                parser.setNodeFactory(new SwingNodeFactory());
                parser.setFlatView(true);
                parser.setParsingMode(0);
                try {
                    parser.parse();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Document document = parser.getDocument();
                DiffPanel.this.leftTree.setModel(new CustomTreeModel(string, (TreeNode)((Object)document.getRoot())));
                DefaultTableModel defaultTableModel = new DefaultTableModel(new String[]{"T", "Click on a row for selecting in the tree"}, 0);
                FastVector fastVector = document.getFlatNodes();
                boolean bl = this.filterType > -1;
                boolean bl2 = this.filterType > -1;
                boolean bl3 = this.filterType > -1;
                for (int i = 0; i < fastVector.size(); ++i) {
                    SimpleNode simpleNode = (SimpleNode)fastVector.get(i);
                    int n = CustomTreeRenderer.guessType(simpleNode);
                    if (n <= -1 || this.filterType != -1 && this.filterType != n) continue;
                    String string3 = null;
                    switch (n) {
                        case 0: {
                            string3 = "The node ( element ) " + simpleNode.getContent() + " has been added";
                            if (this.filterType != -1) break;
                            bl = true;
                            break;
                        }
                        case 2: {
                            if (this.filterType == -1) {
                                bl3 = true;
                            }
                            String string4 = "";
                            for (int j = 0; j < simpleNode.getViewAttributeCount(); ++j) {
                                String string5 = simpleNode.getViewAttributeAt(j);
                                if (string5.startsWith("del:")) {
                                    if (!"".equals(string4)) {
                                        string4 = string4 + " / ";
                                    }
                                    string4 = string4 + string5.substring(4) + "=" + simpleNode.getAttribute(string5);
                                }
                                string3 = "The attribute(s) " + string4 + " has been deleted";
                            }
                            break;
                        }
                        case 1: {
                            if (this.filterType == -1) {
                                bl2 = true;
                            }
                            string3 = "The node ( element ) " + simpleNode.getContent() + " has been deleted";
                        }
                    }
                    simpleNode.setApplicationObject(string3);
                    defaultTableModel.addRow(new Object[]{new Integer(n), simpleNode});
                }
                DiffPanel.this.tbBottom.setModel(defaultTableModel);
                DiffPanel.this.tbBottom.getColumnModel().getColumn(0).setCellRenderer(new CustomTypeRenderer());
                DiffPanel.this.tbBottom.getColumnModel().getColumn(1).setCellRenderer(new CustomMsgRenderer());
                DiffPanel.this.tbBottom.getColumnModel().getColumn(0).setMaxWidth(16);
                if (defaultTableModel.getRowCount() == 0) {
                    EditixFactory.buildAndShowInformationDialog("Documents are equal");
                    DiffPanel.this.btReportEdit.setEnabled(false);
                    DiffPanel.this.btReportFile.setEnabled(false);
                    DiffPanel.this.btRefresh.setEnabled(false);
                    DiffPanel.this.btAdded.setEnabled(false);
                    DiffPanel.this.btDelete.setEnabled(false);
                    DiffPanel.this.btAtt.setEnabled(false);
                } else {
                    DiffPanel.this.btReportEdit.setEnabled(true);
                    DiffPanel.this.btReportFile.setEnabled(true);
                    DiffPanel.this.btRefresh.setEnabled(true);
                    DiffPanel.this.btAdded.setEnabled(bl);
                    DiffPanel.this.btDelete.setEnabled(bl2);
                    DiffPanel.this.btAtt.setEnabled(bl3);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                EditixFactory.buildAndShowErrorDialog("Can't compare : " + fileNotFoundException.getMessage());
                EditixApplicationModel.debug(fileNotFoundException);
            }
            catch (DiffXException diffXException) {
                EditixFactory.buildAndShowErrorDialog("Can't compare : " + diffXException.getMessage());
                EditixApplicationModel.debug(diffXException);
            }
            catch (IOException iOException) {
                EditixFactory.buildAndShowErrorDialog("Can't compare : " + iOException.getMessage());
            }
            catch (Exception exception) {
                EditixFactory.buildAndShowErrorDialog("Can't compare : " + exception.getMessage());
            }
            catch (Throwable throwable) {
                EditixApplicationModel.debug(throwable);
            }
            DiffPanel.this.dt = null;
        }
    }
}

