/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.db.ui;

import com.japisoft.editix.action.file.OpenAction;
import com.japisoft.editix.action.file.SaveActionDelegate;
import com.japisoft.editix.db.ContainerNodeDb;
import com.japisoft.editix.db.Driver;
import com.japisoft.editix.db.DriverDbManager;
import com.japisoft.editix.db.FileNodeDb;
import com.japisoft.editix.db.NodeDb;
import com.japisoft.editix.db.RootNodeDb;
import com.japisoft.editix.db.ui.DbBrowserTreeRenderer;
import com.japisoft.editix.db.ui.DbConnectionPanel;
import com.japisoft.editix.db.ui.DbRequestPanel;
import com.japisoft.editix.db.ui.Editable;
import com.japisoft.editix.document.DocumentModel;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.framework.app.toolkit.Toolkit;
import com.japisoft.framework.dialog.DialogManager;
import com.japisoft.framework.xml.XMLFileData;
import com.japisoft.xmlpad.SharedProperties;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.XMLDocumentInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DbBrowser
extends JPanel
implements MouseListener,
TreeSelectionListener {
    protected JTree t = null;
    RefreshAction ra = null;
    DeleteAction da = null;
    EditAction ea = null;
    DbRequestPanel reqPnl = null;

    public DbBrowser() {
        this.initActions();
        this.initUi();
    }

    protected void initActions() {
        this.ra = new RefreshAction();
        this.da = new DeleteAction();
        this.ea = new EditAction();
    }

    protected void initUi() {
        this.setLayout(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(new ConnectAction());
        jToolBar.add(this.ra);
        jToolBar.add(new NewAction());
        jToolBar.add(this.da);
        this.add((Component)jToolBar, "North");
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Your databases");
        JSplitPane jSplitPane = new JSplitPane(0);
        this.t = new JTree(new DefaultTreeModel(defaultMutableTreeNode));
        jSplitPane.setTopComponent(new JScrollPane(this.t));
        this.reqPnl = new DbRequestPanel(this);
        jSplitPane.setBottomComponent(this.reqPnl);
        jSplitPane.setDividerLocation(180);
        this.add((Component)jSplitPane, "Center");
        this.t.setCellRenderer(new DbBrowserTreeRenderer());
        jSplitPane.setOneTouchExpandable(true);
    }

    public DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)this.t.getModel().getRoot();
    }

    public void refreshRoot() {
        ((DefaultTreeModel)this.t.getModel()).nodeStructureChanged(this.getRoot());
    }

    public RootNodeDb getCurrentConnection() {
        TreePath treePath = this.t.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        Object object = treePath.getLastPathComponent();
        if (object instanceof NodeDb) {
            NodeDb nodeDb = (NodeDb)object;
            while (!(nodeDb instanceof RootNodeDb) && nodeDb.getParent() instanceof NodeDb) {
                nodeDb = (NodeDb)nodeDb.getParent();
            }
            if (nodeDb instanceof RootNodeDb) {
                return (RootNodeDb)nodeDb;
            }
            return null;
        }
        return null;
    }

    public Driver getCurrentDriver() {
        RootNodeDb rootNodeDb = this.getCurrentConnection();
        if (rootNodeDb == null) {
            return null;
        }
        String string = rootNodeDb.getDriverName();
        if (string == null) {
            return null;
        }
        return DriverDbManager.getDriverByName(string);
    }

    public ContainerNodeDb getCurrentContainer() {
        TreePath treePath = this.t.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        Object object = treePath.getLastPathComponent();
        if (object instanceof NodeDb) {
            NodeDb nodeDb = (NodeDb)object;
            while (!(nodeDb instanceof ContainerNodeDb)) {
                nodeDb = (NodeDb)nodeDb.getParent();
            }
            return (ContainerNodeDb)nodeDb;
        }
        return null;
    }

    public void close() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getRoot();
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            TreeNode treeNode = defaultMutableTreeNode.getChildAt(i);
            if (!(treeNode instanceof NodeDb)) continue;
            ((NodeDb)treeNode).close();
        }
        defaultMutableTreeNode.removeAllChildren();
    }

    public void addNotify() {
        super.addNotify();
        this.t.addMouseListener(this);
        this.t.addTreeSelectionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.t.removeMouseListener(this);
        this.t.removeTreeSelectionListener(this);
    }

    public void initTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getRoot();
        if (defaultMutableTreeNode.getChildCount() > 0) {
            this.t.expandPath(new TreePath(defaultMutableTreeNode));
            com.japisoft.framework.ui.toolkit.Toolkit.selectFirstChild(this.t, defaultMutableTreeNode);
        }
    }

    public void refresh(NodeDb nodeDb) {
        nodeDb.close();
        try {
            nodeDb.open();
            ((DefaultTreeModel)this.t.getModel()).nodeStructureChanged(nodeDb);
        }
        catch (Exception exception) {
            EditixFactory.buildAndShowErrorDialog("Can't refresh " + exception.getMessage());
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Driver driver;
        TreePath treePath = this.t.getSelectionPath();
        if (treePath != null) {
            if (treePath.getLastPathComponent() instanceof RootNodeDb) {
                this.da.setEnabled(true);
            } else if (treePath.getLastPathComponent() instanceof ContainerNodeDb) {
                driver = this.getCurrentDriver();
                if (driver != null && !driver.canRemoveContainer) {
                    this.da.setEnabled(false);
                } else {
                    this.da.setEnabled(((NodeDb)treePath.getLastPathComponent()).canBeDeleted());
                }
            } else if (treePath.getLastPathComponent() instanceof NodeDb) {
                this.da.setEnabled(((NodeDb)treePath.getLastPathComponent()).canBeDeleted());
            } else {
                this.da.setEnabled(false);
            }
        }
        if ((driver = this.getCurrentDriver()) != null) {
            this.reqPnl.setEnabledRequest(driver.query);
        }
    }

    private FileNodeDb getFileNodeByName(TreeNode treeNode, String string) {
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            NodeDb nodeDb = (NodeDb)treeNode.getChildAt(i);
            if (!(nodeDb instanceof FileNodeDb) || !string.equalsIgnoreCase(nodeDb.toString())) continue;
            return (FileNodeDb)nodeDb;
        }
        return null;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            this.readCurrentFileNode(null);
        }
    }

    public void read(FileNodeDb fileNodeDb, String string) {
        Object object;
        if (fileNodeDb instanceof Editable && !(object = (Editable)((Object)fileNodeDb)).canEdit()) {
            EditixFactory.buildAndShowWarningDialog("Can't edit this node");
            return;
        }
        try {
            object = fileNodeDb.getContent();
            String string2 = null;
            XMLFileData xMLFileData = new XMLFileData(null, (String)object);
            String string3 = fileNodeDb.toString();
            DbEntityResolver dbEntityResolver = null;
            if (fileNodeDb.getParent() instanceof ContainerNodeDb) {
                dbEntityResolver = new DbEntityResolver((ContainerNodeDb)fileNodeDb.getParent());
            }
            string2 = string != null ? string : DocumentModel.getTypeForFileName(string3);
            OpenAction.openFile(string2, true, null, string3, null, xMLFileData, new SaveActionDelegateImpl(fileNodeDb), dbEntityResolver);
        }
        catch (Exception exception) {
            EditixFactory.buildAndShowErrorDialog("Can't read : " + exception.getMessage());
        }
    }

    private void readCurrentFileNode(String string) {
        TreeNode treeNode;
        if (this.t.getSelectionPath() != null && (treeNode = (TreeNode)this.t.getSelectionPath().getLastPathComponent()) instanceof FileNodeDb) {
            FileNodeDb fileNodeDb = (FileNodeDb)treeNode;
            this.read(fileNodeDb, string);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3) {
            Object object;
            int n;
            Object object2;
            TreePath treePath = this.t.getSelectionPath();
            TreeNode treeNode = null;
            if (treePath != null) {
                treeNode = (TreeNode)treePath.getLastPathComponent();
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            if (treeNode instanceof FileNodeDb) {
                jPopupMenu.add(this.ea);
                object2 = new JMenu("Edit as");
                for (n = 0; n < DocumentModel.getDocumentCount(); ++n) {
                    XMLDocumentInfo xMLDocumentInfo = DocumentModel.getDocumentAt(n);
                    object = xMLDocumentInfo.getDocumentDescription();
                    String string = xMLDocumentInfo.getType();
                    ((JMenu)object2).add(new EditAction(string, (String)object, xMLDocumentInfo.getDocumentIcon()));
                }
                jPopupMenu.add((JMenuItem)object2);
            }
            jPopupMenu.add(this.ra);
            object2 = this.getCurrentDriver();
            n = 1;
            boolean bl = true;
            if (object2 != null) {
                n = ((Driver)object2).canRemoveContainer ? 1 : 0;
                bl = ((Driver)object2).canAddContainer;
            }
            if (treeNode instanceof NodeDb && ((NodeDb)treeNode).canBeDeleted()) {
                if (treeNode instanceof ContainerNodeDb) {
                    if (n != 0) {
                        jPopupMenu.addSeparator();
                        jPopupMenu.add(this.da);
                    }
                } else {
                    jPopupMenu.addSeparator();
                    jPopupMenu.add(this.da);
                }
            }
            if (treeNode instanceof ContainerNodeDb) {
                object = (ContainerNodeDb)treeNode;
                if (bl && object.canCreateSubContainer()) {
                    jPopupMenu.addSeparator();
                    jPopupMenu.add(new AddContainerAction());
                }
            }
            jPopupMenu.show(this.t, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    class DbEntityResolver
    implements EntityResolver {
        private ContainerNodeDb container;

        public DbEntityResolver(ContainerNodeDb containerNodeDb) {
            this.container = containerNodeDb;
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            if (string2 != null) {
                int n;
                if (string2.startsWith("file:") && (n = string2.lastIndexOf("/")) > -1) {
                    string2 = string2.substring(n + 1);
                }
                if (!string2.contains("/") && !string2.contains("\\")) {
                    for (n = 0; n < this.container.getChildCount(); ++n) {
                        FileNodeDb fileNodeDb;
                        NodeDb nodeDb = (NodeDb)this.container.getChildAt(n);
                        if (!(nodeDb instanceof FileNodeDb) || !string2.equalsIgnoreCase((fileNodeDb = (FileNodeDb)nodeDb).toString())) continue;
                        try {
                            String string3 = fileNodeDb.getContent();
                            return new InputSource(new ByteArrayInputStream(string3.getBytes()));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            if (SharedProperties.DEFAULT_ENTITY_RESOLVER != null) {
                return SharedProperties.DEFAULT_ENTITY_RESOLVER.resolveEntity(string, string2);
            }
            return null;
        }
    }

    class SaveActionDelegateImpl
    implements SaveActionDelegate {
        private FileNodeDb fileRef;

        SaveActionDelegateImpl(FileNodeDb fileNodeDb) {
            this.fileRef = fileNodeDb;
        }

        public boolean save(XMLContainer xMLContainer) {
            try {
                this.fileRef.setContent(xMLContainer.getText());
                xMLContainer.setModifiedState(false);
            }
            catch (Exception exception) {
                EditixFactory.buildAndShowErrorDialog("<html><body><b>Can't save this document</b><p style='width:500px'>" + exception.getMessage() + "</p></body></html>");
                return false;
            }
            return true;
        }
    }

    class ConnectAction
    extends AbstractAction {
        public ConnectAction() {
            this.putValue("Name", "Connect");
            this.putValue("ShortDescription", "Add a database connection");
            this.putValue("SmallIcon", Toolkit.getImageIcon("images/data_add.png"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DriverDbManager.install();
            DbConnectionPanel dbConnectionPanel = new DbConnectionPanel();
            if (DialogManager.showDialog(EditixFrame.ACCESSOR, "Connection", "Database connection", "Choose a database driver and connect", null, dbConnectionPanel) == DialogManager.OK_ID) {
                Driver driver = dbConnectionPanel.getDriver();
                try {
                    RootNodeDb rootNodeDb = driver.getRoot(dbConnectionPanel.getUrl(), dbConnectionPanel.getUser(), dbConnectionPanel.getPassword());
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)DbBrowser.this.t.getModel().getRoot();
                    defaultMutableTreeNode.add(rootNodeDb);
                    ((DefaultTreeModel)DbBrowser.this.t.getModel()).nodeStructureChanged(defaultMutableTreeNode);
                    com.japisoft.framework.ui.toolkit.Toolkit.selectFirstChild(DbBrowser.this.t, rootNodeDb);
                }
                catch (Exception exception) {
                    EditixFactory.buildAndShowErrorDialog("Can't connect : " + exception.getMessage());
                }
            }
        }
    }

    class RefreshAction
    extends AbstractAction {
        public RefreshAction() {
            this.putValue("Name", "Refresh");
            this.putValue("ShortDescription", "Refresh the current container or connection");
            this.putValue("SmallIcon", Toolkit.getImageIcon("images/data_refresh.png"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreeNode treeNode;
            TreePath treePath = DbBrowser.this.t.getSelectionPath();
            if (treePath != null && (treeNode = (TreeNode)treePath.getLastPathComponent()) instanceof NodeDb) {
                DbBrowser.this.refresh((NodeDb)treeNode);
            }
        }
    }

    class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            this.putValue("Name", "Delete");
            this.putValue("ShortDescription", "Delete a file or a connection");
            this.putValue("SmallIcon", Toolkit.getImageIcon("images/delete2.png"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block9: {
                TreePath treePath = DbBrowser.this.t.getSelectionPath();
                if (treePath != null) {
                    TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
                    if (treeNode instanceof NodeDb) {
                        NodeDb nodeDb = (NodeDb)treeNode;
                        TreeNode treeNode2 = nodeDb.getParent();
                        if (!nodeDb.canBeDeleted()) {
                            EditixFactory.buildAndShowWarningDialog("Can't delete this node ");
                        } else {
                            try {
                                String string = "Delete " + nodeDb + " ?";
                                if (nodeDb instanceof RootNodeDb) {
                                    string = "Remove this connection to " + nodeDb + " ?";
                                }
                                if (!EditixFactory.buildAndShowConfirmDialog(string)) break block9;
                                if (!nodeDb.delete()) {
                                    EditixFactory.buildAndShowWarningDialog("Can't delete this node ");
                                    break block9;
                                }
                                ((DefaultTreeModel)DbBrowser.this.t.getModel()).nodeStructureChanged(treeNode2);
                            }
                            catch (Exception exception) {
                                EditixFactory.buildAndShowErrorDialog("Can't delete : " + exception.getMessage());
                            }
                        }
                    } else {
                        EditixFactory.buildAndShowWarningDialog("Can't delete this node ");
                    }
                }
            }
        }
    }

    class NewAction
    extends AbstractAction {
        public NewAction() {
            this.putValue("Name", "New");
            this.putValue("ShortDescription", "Create a new document");
            this.putValue("SmallIcon", Toolkit.getImageIcon("images/document_new.png"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block11: {
                TreePath treePath = DbBrowser.this.t.getSelectionPath();
                if (treePath != null) {
                    TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
                    if (treeNode instanceof FileNodeDb) {
                        treeNode = treeNode.getParent();
                    }
                    if (treeNode instanceof ContainerNodeDb) {
                        String string = EditixFactory.buildAndShowInputDialog("Your file name ?");
                        if (string != null) {
                            boolean bl = true;
                            FileNodeDb fileNodeDb = DbBrowser.this.getFileNodeByName(treeNode, string);
                            if (fileNodeDb != null) {
                                EditixFactory.buildAndShowWarningDialog("This file already exists");
                                bl = false;
                            }
                            if (bl) {
                                try {
                                    ((ContainerNodeDb)treeNode).setContent(string, "<?xml version='1.0'?>\n\n<myFile/>");
                                    DbBrowser.this.refresh((NodeDb)treeNode);
                                    fileNodeDb = DbBrowser.this.getFileNodeByName(treeNode, string);
                                    if (fileNodeDb == null) {
                                        EditixFactory.buildAndShowWarningDialog("The file cannot be created");
                                        break block11;
                                    }
                                    com.japisoft.framework.ui.toolkit.Toolkit.selectNode(DbBrowser.this.t, fileNodeDb);
                                }
                                catch (Exception exception) {
                                    EditixFactory.buildAndShowErrorDialog("Can't create " + string + " / " + exception.getMessage());
                                }
                            }
                        }
                    } else {
                        EditixFactory.buildAndShowWarningDialog("Please select a container for creating your file");
                    }
                } else {
                    EditixFactory.buildAndShowWarningDialog("Please select a container for creating your file");
                }
            }
        }
    }

    class EditAction
    extends AbstractAction {
        private String forceType = null;

        public EditAction() {
            this.putValue("Name", "Edit");
            this.putValue("ShortDescription", "Edit the current node (or double - click )");
        }

        public EditAction(String string, String string2, Icon icon) {
            this();
            this.forceType = string;
            this.putValue("Name", "Edit as " + string2);
            this.putValue("SmallIcon", icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DbBrowser.this.readCurrentFileNode(this.forceType);
        }
    }

    class AddContainerAction
    extends AbstractAction {
        public AddContainerAction() {
            this.putValue("Name", "Add a container");
            this.putValue("ShortDescription", "Add a container");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreePath treePath = DbBrowser.this.t.getSelectionPath();
            if (treePath != null && treePath.getLastPathComponent() instanceof ContainerNodeDb) {
                ContainerNodeDb containerNodeDb = (ContainerNodeDb)treePath.getLastPathComponent();
                if (containerNodeDb.canCreateSubContainer()) {
                    String string = EditixFactory.buildAndShowInputDialog("Container name ?");
                    if (string != null) {
                        try {
                            ContainerNodeDb containerNodeDb2 = containerNodeDb.createSubContainer(string);
                            if (containerNodeDb2 != null) {
                                ((DefaultTreeModel)DbBrowser.this.t.getModel()).nodeStructureChanged(containerNodeDb);
                                com.japisoft.framework.ui.toolkit.Toolkit.selectNode(DbBrowser.this.t, containerNodeDb2);
                            }
                        }
                        catch (Exception exception) {
                            EditixFactory.buildAndShowErrorDialog("Can't create a container : " + exception.getMessage());
                        }
                    }
                } else {
                    EditixFactory.buildAndShowWarningDialog("Can't create a container");
                }
            }
        }
    }
}

