/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.xml;

import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.ApplicationModel;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.xml.validator.DefaultValidator;
import com.japisoft.xmlpad.xml.validator.RelaxNGValidator;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

public class EditixValidator
extends DefaultValidator {
    protected boolean canValidate(XMLContainer xMLContainer) {
        SimpleNode simpleNode;
        String string = "xml";
        if (xMLContainer.getDocumentInfo() != null) {
            string = xMLContainer.getDocumentInfo().getType();
        }
        if ((simpleNode = xMLContainer.getRootNode()) != null) {
            String string2;
            if ("XSLT".equals(string)) {
                String string3 = simpleNode.getAttribute("version");
                if ("2.0".equals(string3)) {
                    EditixFactory.buildAndShowWarningDialog("You are using an xslt 2.0 document, but your document type was for xslt 1.0, please reopen your document as an XSLT 2.0");
                }
            } else if ("XSLT2".equals(string) && "1.0".equals(string2 = simpleNode.getAttribute("version"))) {
                EditixFactory.buildAndShowWarningDialog("You are using an xslt 1.0 document, but your document type was for xslt 2.0, please reopen your document as an XSLT 1.0");
            }
        }
        return super.canValidate(xMLContainer);
    }

    protected SAXParser buildCustomParser(XMLContainer xMLContainer) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL uRL = xMLContainer.getDocumentInfo().getSchemaXSDValid();
            Schema schema = schemaFactory.newSchema(uRL);
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setSchema(schema);
            return sAXParserFactory.newSAXParser();
        }
        catch (Throwable throwable) {
            ApplicationModel.debug(throwable);
            return null;
        }
    }

    protected boolean postAction(XMLContainer xMLContainer, boolean bl) {
        if (xMLContainer.getDocumentInfo().getSchemaRNGValid() != null) {
            URL uRL = xMLContainer.getDocumentInfo().getSchemaRNGValid();
            String string = uRL.toExternalForm();
            string = string.replace("%20", " ");
            xMLContainer.getSchemaAccessibility().setRelaxNGValidationLocation(string);
            RelaxNGValidator relaxNGValidator = new RelaxNGValidator();
            xMLContainer.getErrorManager().initErrorProcessing();
            relaxNGValidator.validate(xMLContainer, bl);
            xMLContainer.getErrorManager().stopErrorProcessing();
            return relaxNGValidator.error;
        }
        return false;
    }
}

