/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.view;

import com.japisoft.editix.ui.EditixDialog;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.framework.ui.toolkit.BrowserCaller;
import com.japisoft.xmlpad.XMLContainer;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;

public class HTMLView
extends AbstractAction {
    public void actionPerformed(ActionEvent actionEvent) {
        XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
        if (xMLContainer == null) {
            return;
        }
        if (xMLContainer.getCurrentDocumentLocation() != null) {
            BrowserCaller.displayURL(xMLContainer.getCurrentDocumentLocation());
        } else {
            int n;
            String string = xMLContainer.getText();
            if (string.startsWith("<?") && (n = string.indexOf("\n")) > -1) {
                string = string.substring(n);
            }
            HTMLDialog hTMLDialog = new HTMLDialog(string);
            Point point = (Point)xMLContainer.getProperty("view.html.location");
            Dimension dimension = (Dimension)xMLContainer.getProperty("view.html.dimension");
            if (point != null) {
                hTMLDialog.setLocation(point);
            }
            if (dimension != null) {
                hTMLDialog.setSize(dimension);
            }
            if (point != null) {
                hTMLDialog.setVisible(true);
            } else {
                hTMLDialog.setVisible(true);
            }
            if (hTMLDialog.isOk()) {
                xMLContainer.setProperty("view.html.location", hTMLDialog.getLocation());
                xMLContainer.setProperty("view.html.dimension", hTMLDialog.getSize());
            }
        }
    }

    class HTMLDialog
    extends EditixDialog {
        HTMLDialog(String string) {
            super("XHTML", "HTML View", "This is a mini browser.\nSave your document for displaying it inside a system viewer");
            JEditorPane jEditorPane = new JEditorPane("text/html", string);
            jEditorPane.setEditable(false);
            this.getContentPane().add(new JScrollPane(jEditorPane));
        }

        protected Dimension getDefaultSize() {
            return new Dimension(400, 400);
        }
    }
}

