/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.file;

import com.japisoft.editix.action.file.imp.HTMLImport;
import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.xml.XMLFileData;
import com.japisoft.framework.xml.XMLToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.layout.GroupLayout;

public class ImportURLUI
extends JPanel
implements ActionListener,
ItemListener {
    private String storingPath = ApplicationModel.getAppUserPath().toString();
    private ButtonGroup bgpMethod;
    private JButton btnRemove;
    private JButton btnSave;
    private JCheckBox cbConvertHTML;
    private JComboBox cbURL;
    private JLabel lblMethod;
    private JLabel lblURL;
    private JRadioButton rbGet;
    private JRadioButton rbPost;
    private JScrollPane spParams;
    private JTable tbParams;

    public ImportURLUI() {
        this.initComponents();
    }

    public void addNotify() {
        this.btnSave.addActionListener(this);
        this.btnRemove.addActionListener(this);
        this.cbURL.addItemListener(this);
        super.addNotify();
        this.init();
    }

    public void removeNotify() {
        this.btnSave.removeActionListener(this);
        this.btnRemove.removeActionListener(this);
        this.cbURL.removeItemListener(this);
        super.removeNotify();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnSave) {
            this.saveIt();
        } else {
            this.deleteIt();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = this.getURL();
        this.select(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void select(String string) {
        File file = this.getFileForURL(string);
        if (file == null) {
            return;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            try {
                int n;
                bufferedReader.readLine();
                this.rbGet.setSelected(bufferedReader.readLine().equals("true"));
                this.rbPost.setSelected(bufferedReader.readLine().equals("true"));
                String string2 = null;
                TableModel tableModel = this.tbParams.getModel();
                int n2 = 0;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.indexOf("=") > -1) {
                        n = string2.indexOf("=");
                        String string3 = string2.substring(0, n);
                        String string4 = string2.substring(n + 1);
                        tableModel.setValueAt(string3, n2, 0);
                        tableModel.setValueAt(string4, n2, 1);
                        ++n2;
                        continue;
                    }
                    this.cbConvertHTML.setSelected(string2.equals("true"));
                    break;
                }
                for (n = n2; n < tableModel.getRowCount(); ++n) {
                    tableModel.setValueAt("", n, 0);
                    tableModel.setValueAt("", n, 1);
                }
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getURL() {
        return "" + this.cbURL.getSelectedItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveIt() {
        Object object;
        int n;
        Object object2;
        if ("".equals(this.getURL())) {
            return;
        }
        File file = this.getFileForURL(this.getURL());
        if (file == null) {
            object2 = new File(this.storingPath).list();
            int n2 = 0;
            for (n = 0; object2 != null && n < ((Object)object2).length; ++n) {
                object = object2[n];
                if (!((String)object).endsWith(".url")) continue;
                int n3 = ((String)object).lastIndexOf(".");
                String string = ((String)object).substring(0, n3);
                try {
                    n2 = Math.max(Integer.parseInt(string), n2);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            file = new File(this.storingPath, n2 + 1 + ".url");
        }
        try {
            object2 = new BufferedWriter(new FileWriter(file));
            try {
                ((Writer)object2).write(this.getURL());
                ((BufferedWriter)object2).newLine();
                ((Writer)object2).write("" + this.rbGet.isSelected());
                ((BufferedWriter)object2).newLine();
                ((Writer)object2).write("" + this.rbPost.isSelected());
                TableModel tableModel = this.tbParams.getModel();
                for (n = 0; n < tableModel.getRowCount(); ++n) {
                    object = (String)tableModel.getValueAt(n, 0);
                    String string = (String)tableModel.getValueAt(n, 1);
                    if (object == null || string == null) continue;
                    ((BufferedWriter)object2).newLine();
                    ((Writer)object2).write((String)object + "=" + string);
                }
                ((BufferedWriter)object2).newLine();
                ((Writer)object2).write("" + this.cbConvertHTML.isSelected());
                n = 0;
                for (int i = 0; i < this.cbURL.getItemCount(); ++i) {
                    if (!this.getURL().equals(this.cbURL.getItemAt(i))) continue;
                    n = 1;
                    break;
                }
                if (n == 0) {
                    this.cbURL.addItem(this.getURL());
                }
            }
            finally {
                ((BufferedWriter)object2).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void deleteIt() {
        File file = this.getFileForURL(this.getURL());
        if (file != null) {
            file.delete();
        }
        this.init();
    }

    private void init() {
        this.updateState();
        if (this.cbURL.getItemCount() > 0) {
            this.select((String)this.cbURL.getItemAt(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateState() {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        String[] stringArray = new File(this.storingPath).list();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.endsWith(".url")) continue;
            File file = new File(this.storingPath, string);
            try {
                FileReader fileReader = new FileReader(file);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                try {
                    String string2 = bufferedReader.readLine();
                    defaultComboBoxModel.addElement(string2);
                    continue;
                }
                finally {
                    bufferedReader.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.cbURL.setModel(defaultComboBoxModel);
        if (this.cbURL.getItemCount() > 0) {
            this.cbURL.setSelectedIndex(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File getFileForURL(String string) {
        String[] stringArray = new File(this.storingPath).list();
        int i = 0;
        while (stringArray != null) {
            if (i >= stringArray.length) return null;
            String string2 = stringArray[i];
            if (string2.endsWith(".url")) {
                File file = new File(this.storingPath, string2);
                try {
                    FileReader fileReader = new FileReader(file);
                    BufferedReader bufferedReader = new BufferedReader(fileReader);
                    try {
                        String string3 = bufferedReader.readLine();
                        if (string3.equalsIgnoreCase(string)) {
                            File file2 = file;
                            return file2;
                        }
                    }
                    finally {
                        bufferedReader.close();
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++i;
        }
        return null;
    }

    public XMLFileData connect(String string) throws Throwable {
        Object object;
        Object object2;
        String string2 = (String)this.cbURL.getSelectedItem();
        TableModel tableModel = this.tbParams.getModel();
        URL uRL = null;
        if (this.rbPost.isSelected()) {
            uRL = new URL(string2);
        }
        String string3 = "";
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            object2 = (String)tableModel.getValueAt(i, 0);
            object = (String)tableModel.getValueAt(i, 1);
            if (object2 == null || object == null || "".equals(object2) || "".equals(object)) continue;
            if (this.rbGet.isSelected() && string2.indexOf("?") == -1) {
                string2 = string2 + "?";
            }
            if (!"".equals(string3)) {
                string3 = string3 + "&";
            }
            string3 = string3 + URLEncoder.encode((String)object2) + "=" + URLEncoder.encode((String)object);
        }
        if (this.rbGet.isSelected()) {
            uRL = new URL(string2 + string3);
        }
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoOutput(this.rbPost.isSelected());
        uRLConnection.setRequestProperty("user-agent", "Mozilla");
        if (this.rbPost.isSelected() && !string3.equals("")) {
            uRLConnection.getOutputStream().write(string3.getBytes());
        }
        object2 = uRLConnection.getInputStream();
        if (this.cbConvertHTML.isSelected() && (object = (Object)HTMLImport.convertHTMLInputStream((InputStream)object2)) != null) {
            object2 = new ByteArrayInputStream((byte[])object);
        }
        object = XMLToolkit.getContentFromInputStream((InputStream)object2, string);
        return object;
    }

    private void initComponents() {
        this.bgpMethod = new ButtonGroup();
        this.lblURL = new JLabel();
        this.cbURL = new JComboBox();
        this.lblMethod = new JLabel();
        this.rbGet = new JRadioButton();
        this.rbPost = new JRadioButton();
        this.spParams = new JScrollPane();
        this.tbParams = new JTable();
        this.cbConvertHTML = new JCheckBox();
        this.btnSave = new JButton();
        this.btnRemove = new JButton();
        this.lblURL.setText("URL :");
        this.cbURL.setEditable(true);
        this.lblMethod.setText("HTTP Method :");
        this.bgpMethod.add(this.rbGet);
        this.rbGet.setSelected(true);
        this.rbGet.setText("GET");
        this.rbGet.setToolTipText("HTTP GET Method");
        this.rbGet.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbGet.setMargin(new Insets(0, 0, 0, 0));
        this.bgpMethod.add(this.rbPost);
        this.rbPost.setText("POST");
        this.rbPost.setToolTipText("HTTP Post Method");
        this.rbPost.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbPost.setMargin(new Insets(0, 0, 0, 0));
        this.tbParams.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Param", "Value"}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }
        });
        this.spParams.setViewportView(this.tbParams);
        this.cbConvertHTML.setText("Convert HTML to XHTML");
        this.cbConvertHTML.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbConvertHTML.setMargin(new Insets(0, 0, 0, 0));
        this.btnSave.setText("Save");
        this.btnSave.setToolTipText("Save in the history");
        this.btnRemove.setText("Remove");
        this.btnRemove.setToolTipText("Remove from the history");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.spParams, -1, 380, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblURL).addPreferredGap(0).add((Component)this.cbURL, 0, 350, Short.MAX_VALUE)).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblMethod).addPreferredGap(0).add((Component)this.rbGet).addPreferredGap(0).add((Component)this.rbPost).addPreferredGap(0, 85, Short.MAX_VALUE).add((Component)this.btnSave).addPreferredGap(0).add((Component)this.btnRemove)).add(1, (Component)this.cbConvertHTML)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblURL).add((Component)this.cbURL, -2, -1, -2)).add(20, 20, 20).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblMethod).add((Component)this.rbGet).add((Component)this.rbPost).add((Component)this.btnSave).add((Component)this.btnRemove)).addPreferredGap(0).add((Component)this.spParams, -1, 221, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.cbConvertHTML).addContainerGap()));
    }
}

