/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.dtdschema.generator.transformer;

import com.japisoft.editix.action.dtdschema.generator.MetaAttribute;
import com.japisoft.editix.action.dtdschema.generator.MetaNode;
import com.japisoft.editix.action.dtdschema.generator.MetaObject;
import com.japisoft.editix.action.dtdschema.generator.Transformer;
import java.util.ArrayList;

public class DTDTransformer
implements Transformer {
    public String getType() {
        return "DTD";
    }

    public String transform(MetaNode metaNode, ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.generateElement((MetaNode)arrayList.get(i), arrayList, stringBuffer);
        }
        return stringBuffer.toString();
    }

    public boolean hasVersion() {
        return false;
    }

    private void generateElement(MetaNode metaNode, ArrayList arrayList, StringBuffer stringBuffer) {
        MetaObject metaObject;
        int n;
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("<!ELEMENT ").append(metaNode.getName()).append("  ");
        if (metaNode.getChildren().size() == 0) {
            if (metaNode.acceptText()) {
                stringBuffer.append("( #PCDATA )");
            } else {
                stringBuffer.append("EMPTY");
            }
        }
        for (n = 0; n < metaNode.getChildren().size(); ++n) {
            if (n == 0) {
                stringBuffer.append("( ");
                if (metaNode.acceptText()) {
                    stringBuffer.append("#PCDATA | ");
                }
            }
            if (n > 0) {
                stringBuffer.append(" | ");
            }
            metaObject = (MetaNode)metaNode.getChildren().get(n);
            stringBuffer.append(((MetaNode)metaObject).getName());
            if (n != metaNode.getChildren().size() - 1) continue;
            stringBuffer.append(" )");
            if (metaNode.getChildren().size() > 1) {
                stringBuffer.append("*");
                continue;
            }
            if (!metaNode.hasMultipleOccurence((MetaNode)metaObject)) continue;
            stringBuffer.append("*");
        }
        stringBuffer.append(">").append(System.getProperty("line.separator"));
        if (metaNode.hasAttributes()) {
            stringBuffer.append("<!ATTLIST ").append(metaNode.getName()).append(System.getProperty("line.separator"));
            for (n = 0; n < metaNode.getAttributes().size(); ++n) {
                metaObject = (MetaAttribute)metaNode.getAttributes().get(n);
                String string = this.translateType(((MetaAttribute)metaObject).getType());
                stringBuffer.append(((MetaAttribute)metaObject).getName()).append(" ").append(string).append(" ").append(metaObject.isAlways() ? "#REQUIRED" : "#IMPLIED").append(System.getProperty("line.separator"));
            }
            stringBuffer.append(">").append(System.getProperty("line.separator"));
        }
    }

    private String translateType(String string) {
        String string2 = "CDATA";
        if ("ID".equals(string)) {
            string2 = "ID";
        } else if ("IDREF".equals(string)) {
            string2 = "IDREF";
        }
        return string2;
    }
}

