/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.docbook;

import com.japisoft.editix.EditixApplicationModel;
import com.japisoft.editix.action.docbook.DocBookDialog;
import com.japisoft.editix.action.fop.FOPAction;
import com.japisoft.editix.action.xsl.XSLTAction;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.framework.application.descriptor.ActionModel;
import com.japisoft.framework.job.HeavyJob;
import com.japisoft.framework.job.JobManager;
import com.japisoft.framework.preferences.Preferences;
import com.japisoft.framework.toolkit.FileToolkit;
import com.japisoft.framework.ui.toolkit.BrowserCaller;
import com.japisoft.xmlpad.IXMLPanel;
import com.japisoft.xmlpad.XMLContainer;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.xml.transform.ErrorListener;

public class DocBookAction
extends AbstractAction
implements HeavyJob {
    private XMLContainer docbookContainer;
    String errorMessage = null;

    public void actionPerformed(ActionEvent actionEvent) {
        XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
        if (xMLContainer == null) {
            return;
        }
        IXMLPanel iXMLPanel = EditixFrame.ACCESSOR.getSelectedPanel();
        if (EditixFactory.mustSaveDialog(xMLContainer)) {
            return;
        }
        boolean bl = com.japisoft.xmlpad.action.ActionModel.activeActionByName(com.japisoft.xmlpad.action.ActionModel.SAVE_ACTION, xMLContainer, xMLContainer.getEditor());
        if (!bl) {
            return;
        }
        xMLContainer.setProperty("xslt.data.file", xMLContainer.getCurrentDocumentLocation());
        DocBookDialog docBookDialog = new DocBookDialog();
        docBookDialog.init(xMLContainer);
        docBookDialog.setVisible(true);
        if (docBookDialog.isOk()) {
            docBookDialog.store(xMLContainer);
            DocBookAction.applyTransformation(xMLContainer, true);
        }
        docBookDialog.dispose();
    }

    public void dispose() {
        this.docbookContainer = null;
    }

    public String getName() {
        return "DocBook Transforming";
    }

    public Object getSource() {
        return null;
    }

    public boolean isAlone() {
        return false;
    }

    public void run() {
        this.errorMessage = null;
        boolean bl = DocBookAction.applyTransformation(this.docbookContainer);
        if (!bl) {
            this.errorMessage = "Error found";
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void stopIt() {
    }

    private static URL checkForResource(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        if (uRL != null) {
            return uRL;
        }
        File file = new File(string);
        if (file.exists()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        EditixFactory.buildAndShowErrorDialog("Can't find " + string);
        return null;
    }

    public static void applyTransformation(XMLContainer xMLContainer, boolean bl) {
        if (bl) {
            DocBookAction docBookAction = (DocBookAction)ActionModel.restoreAction("docbookt");
            if (docBookAction == null) {
                System.err.println("Can't find the docbookt action");
            } else {
                docBookAction.docbookContainer = xMLContainer;
                JobManager.addJob(docBookAction);
            }
        } else {
            DocBookAction.applyTransformation(xMLContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean applyTransformation(XMLContainer xMLContainer) {
        Object object;
        String string = (String)xMLContainer.getProperty("docBook.render");
        String string2 = (String)xMLContainer.getProperty("docBook.output");
        boolean bl = "true".equals(xMLContainer.getProperty("docBook.application"));
        xMLContainer.setProperty("xslt.data.file", xMLContainer.getCurrentDocumentLocation());
        URL uRL = null;
        boolean bl2 = false;
        if ("HTML".equals(string)) {
            uRL = DocBookAction.checkForResource(Preferences.getPreference("docbook", "htmlstylesheet", "docbook/html/docbook.xsl"));
            if (uRL == null) {
                return false;
            }
        } else if ("HTML Help".equals(string)) {
            bl = false;
            uRL = DocBookAction.checkForResource(Preferences.getPreference("docbook", "htmlHelperstylesheet", "docbook/htmlhelp/htmlhelp.xsl"));
            if (uRL == null) {
                return false;
            }
            xMLContainer.setProperty("xslt.param.name.0", "base.dir");
            object = new File(string2);
            if (string2.lastIndexOf(".") > -1) {
                object = ((File)object).getParentFile();
            }
            string2 = "docbook.tmp";
            xMLContainer.setProperty("xslt.param.value.0", ((File)object).toString() + "/");
            xMLContainer.setProperty("xslt.param.name.1", "manifest.in.base.dir");
            xMLContainer.setProperty("xslt.param.value.1", "1");
        } else if ("XHTML".equals(string)) {
            uRL = DocBookAction.checkForResource(Preferences.getPreference("docbook", "xhtmlstylesheet", "docbook/xhtml/docbook.xsl"));
            if (uRL == null) {
                return false;
            }
        } else if ("Java Help".equals(string)) {
            bl = false;
            uRL = DocBookAction.checkForResource(Preferences.getPreference("docbook", "javaHelpstylesheet", "docbook/javahelp/javahelp.xsl"));
            if (uRL == null) {
                return false;
            }
        } else if ("FO".equals(string)) {
            bl = false;
            uRL = DocBookAction.checkForResource(Preferences.getPreference("docbook", "fostylesheet", "docbook/fo/docbook.xsl"));
            if (uRL == null) {
                return false;
            }
        } else {
            uRL = DocBookAction.checkForResource(Preferences.getPreference("docbook", "fostylesheet", "docbook/fo/docbook.xsl"));
            if (uRL == null) {
                return false;
            }
            string2 = new File(EditixApplicationModel.getAppUserPath(), "editix.tmp").toString();
            xMLContainer.setProperty("fo.render", string);
            bl2 = true;
        }
        xMLContainer.setProperty("xslt.result.file", string2);
        xMLContainer.setProperty("xslt.xslt.file", FileToolkit.toFile(uRL));
        xMLContainer.setProperty("docbook.ok", "true");
        EditixApplicationModel.debug("Stylesheet " + xMLContainer.getProperty("xslt.xslt.file"));
        object = (ErrorListener)((Object)ActionModel.restoreAction("transformWithXSLT"));
        boolean bl3 = XSLTAction.applyTransformation(xMLContainer, false, false, false, (ErrorListener)object);
        if (bl2 && bl3) {
            xMLContainer.setProperty("fo.output", xMLContainer.getProperty("docBook.output"));
            String string3 = xMLContainer.getCurrentDocumentLocation();
            try {
                xMLContainer.setProperty("file.checker.ignore", "true");
                xMLContainer.getDocumentInfo().setCurrentDocumentLocation(string2);
                FOPAction.applyFO(xMLContainer);
            }
            finally {
                xMLContainer.getDocumentInfo().setCurrentDocumentLocation(string3);
                xMLContainer.setProperty("file.checker.ignore", null);
            }
        }
        if (bl) {
            string2 = (String)xMLContainer.getProperty("docBook.output");
            if (string2.toLowerCase().endsWith("pdf")) {
                try {
                    if (BrowserCaller.isWindowsPlatform()) {
                        Runtime.getRuntime().exec("rundll32 SHELL32.DLL,ShellExec_RunDLL " + string2);
                    }
                }
                catch (IOException iOException) {}
            } else if (string2.toLowerCase().endsWith("html") || string2.toLowerCase().endsWith("htm")) {
                BrowserCaller.displayURL(string2);
            }
        }
        return bl3;
    }

    public static void main(String[] stringArray) {
    }
}

