/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix;

import com.japisoft.dtdparser.DTDMapper;
import com.japisoft.dtdparser.node.RootDTDNode;
import com.japisoft.editix.EditixEntityResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;

public class EditixDTDMapper
implements DTDMapper {
    private static EditixDTDMapper MAPPER = null;
    private String cacheLocation = null;

    private EditixDTDMapper() {
    }

    public static EditixDTDMapper getInstance() {
        if (MAPPER == null) {
            MAPPER = new EditixDTDMapper();
        }
        return MAPPER;
    }

    public boolean isCachedEnabled() {
        return true;
    }

    public File getPathForURL(String string) {
        Object object;
        if (this.cacheLocation == null) {
            object = ClassLoader.getSystemClassLoader().getResource("dtd");
            if (object == null) {
                return null;
            }
            String string2 = ((URL)object).toExternalForm();
            string2 = string2.replaceAll("%20", " ");
            File file = null;
            if (string2.startsWith("file://")) {
                file = new File(string2.substring(7));
            } else if (string2.startsWith("file:")) {
                file = new File(string2.substring(5));
            }
            if (file != null) {
                this.cacheLocation = file.toString();
            } else {
                return null;
            }
        }
        object = string.substring(7);
        return new File(this.cacheLocation, (String)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File updateCache(RootDTDNode rootDTDNode, String string) {
        if (!string.toLowerCase().startsWith("http://")) {
            return null;
        }
        File file = this.getPathForURL(string);
        if (file == null) {
            return null;
        }
        if (file.exists()) {
            return file;
        }
        File file2 = file.getParentFile();
        file2.mkdirs();
        try {
            FileWriter fileWriter = new FileWriter(file);
            try {
                rootDTDNode.writeDTD(new PrintWriter(fileWriter));
            }
            finally {
                fileWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }

    public InputStream getStream(String string) throws IOException {
        if (string.startsWith("http://")) {
            File file;
            String string2 = string.substring(7);
            File file2 = this.getPathForURL(string);
            if (file2 != null && file2.exists()) {
                return new FileInputStream(file2.toString());
            }
            String string3 = EditixEntityResolver.getInstance().resolveCatalog(null, string);
            if (string3 != null && (file = new File(string3)).exists()) {
                return new FileInputStream(string3);
            }
            return new URL(string).openStream();
        }
        String string4 = string;
        File file = new File(string4);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        return null;
    }
}

