/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.dtdparser.node;

import com.japisoft.dtdparser.CannotFindElementException;
import com.japisoft.dtdparser.XMLGenerator;
import com.japisoft.dtdparser.node.AttributeDTDNode;
import com.japisoft.dtdparser.node.DTDNode;
import com.japisoft.dtdparser.node.ElementDTDNode;
import com.japisoft.dtdparser.node.EntityDTDNode;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class RootDTDNode
extends DTDNode
implements XMLGenerator {
    private Hashtable htElement;
    private Hashtable htEntity;
    private boolean preservedComment = true;

    public RootDTDNode() {
        this.setNodeType(4);
    }

    public String getFirstElementName() {
        Enumeration enumeration = this.getDTDNodeForType(2);
        if (enumeration.hasMoreElements()) {
            ElementDTDNode elementDTDNode = (ElementDTDNode)enumeration.nextElement();
            return elementDTDNode.getName();
        }
        return null;
    }

    public boolean isNodeDeclared(String string) {
        if (this.htElement == null) {
            return false;
        }
        return this.htElement.containsKey(string);
    }

    public EntityDTDNode getEntityDeclaration(String string) {
        if (this.htEntity == null) {
            return null;
        }
        return (EntityDTDNode)this.htEntity.get(string);
    }

    public ElementDTDNode getElementDeclaration(String string) {
        if (this.htElement == null) {
            return null;
        }
        if (string == null) {
            return null;
        }
        return (ElementDTDNode)this.htElement.get(string);
    }

    public boolean isNodeValid(String string, String string2, String string3, int n) {
        if (string == null) {
            return this.isNodeDeclared(string3);
        }
        ElementDTDNode elementDTDNode = this.getElementDeclaration(string);
        if (elementDTDNode == null) {
            return false;
        }
        return elementDTDNode.isNodeChildSupported(string3, string2, n);
    }

    public boolean isEntityValid(String string) {
        if (this.htElement == null) {
            return false;
        }
        return this.htElement.containsKey(string);
    }

    public boolean isAttributeValid(String string, String string2) {
        if (this.htElement == null) {
            return false;
        }
        ElementDTDNode elementDTDNode = (ElementDTDNode)this.htElement.get(string);
        if (elementDTDNode == null) {
            return false;
        }
        return elementDTDNode.getAttributeDeclaration(string2) != null;
    }

    public boolean isAttributeValid(String string, String string2, String string3) {
        if (this.htElement == null) {
            return false;
        }
        ElementDTDNode elementDTDNode = (ElementDTDNode)this.htElement.get(string);
        if (elementDTDNode == null) {
            return false;
        }
        AttributeDTDNode attributeDTDNode = elementDTDNode.getAttributeDeclaration(string2);
        if (attributeDTDNode == null) {
            return false;
        }
        return attributeDTDNode.isValueValid(string3);
    }

    public void addDTDNode(DTDNode dTDNode) {
        if (dTDNode.isComment() && !this.isPreservedComment()) {
            return;
        }
        super.addDTDNode(dTDNode);
        if (dTDNode.isElement()) {
            ElementDTDNode elementDTDNode = (ElementDTDNode)dTDNode;
            if (this.htElement == null) {
                this.htElement = new Hashtable();
            }
            this.htElement.put(elementDTDNode.getName(), elementDTDNode);
        } else if (dTDNode.isEntity()) {
            EntityDTDNode entityDTDNode;
            if (this.htEntity == null) {
                this.htEntity = new Hashtable();
            }
            if ((entityDTDNode = (EntityDTDNode)dTDNode).getName() != null) {
                this.htEntity.put(entityDTDNode.getName(), entityDTDNode);
            }
        }
    }

    public ElementDTDNode getElementDefinitionByName(String string) throws CannotFindElementException {
        if (this.htElement == null) {
            return null;
        }
        if (string == null) {
            throw new CannotFindElementException();
        }
        return (ElementDTDNode)this.htElement.get(string);
    }

    public String getEntityValue(String string) {
        if (this.htEntity == null) {
            return null;
        }
        EntityDTDNode entityDTDNode = (EntityDTDNode)this.htEntity.get(string);
        if (entityDTDNode == null) {
            return null;
        }
        return entityDTDNode.getValue();
    }

    public EntityDTDNode getEntityDefinitionByName(String string) {
        return (EntityDTDNode)this.htEntity.get(string);
    }

    public void preserveComment(boolean bl) {
        this.preservedComment = bl;
    }

    public boolean isPreservedComment() {
        return this.preservedComment;
    }

    public void writeDocument(PrintWriter printWriter, String string, String string2, String string3) throws IOException {
        printWriter.write("<?xml version=\"1.0\"");
        if (string != null) {
            printWriter.write(" encoding=\"" + string + "\"");
        }
        printWriter.write(">\n\n");
        if (this.htElement != null) {
            ElementDTDNode elementDTDNode = (ElementDTDNode)this.htElement.get(string2);
            if (elementDTDNode != null) {
                printWriter.write("<!DOCTYPE " + string2 + " SYSTEM \"" + string3 + "\">\n\n");
                elementDTDNode.writeDocument(printWriter);
            } else {
                printWriter.write("<" + string2 + "/>");
            }
        } else {
            printWriter.write("<" + string2 + "/>");
        }
    }

    public void writeDocument(PrintWriter printWriter, String string, String string2) throws IOException {
        this.writeDocument(printWriter, null, string, string2);
    }

    public void writeDTD(PrintWriter printWriter) throws IOException {
        Enumeration enumeration;
        this.writeComment(printWriter);
        if (this.htEntity != null) {
            enumeration = this.htEntity.elements();
            while (enumeration.hasMoreElements()) {
                printWriter.println(enumeration.nextElement());
            }
        }
        printWriter.println();
        printWriter.println();
        if (this.htElement != null) {
            enumeration = this.htElement.elements();
            while (enumeration.hasMoreElements()) {
                printWriter.println("" + enumeration.nextElement());
            }
        } else {
            printWriter.println("<!-- No element found -->");
        }
        printWriter.println();
        printWriter.flush();
    }
}

