/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.dtdparser.node;

import com.japisoft.dtdparser.node.RootDTDNode;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class DTDNode
implements TreeNode {
    private String value;
    private int type;
    private RootDTDNode root;
    private String comment = null;
    private Vector children = null;
    private DTDNode parent;
    private boolean flagged = false;

    public void setNodeType(int n) {
        this.type = n;
    }

    public int getNodeType() {
        return this.type;
    }

    public String toString() {
        return this.value + "(" + this.type + ")";
    }

    public void setRoot(RootDTDNode rootDTDNode) {
        this.root = rootDTDNode;
    }

    public RootDTDNode getRoot() {
        return this.root;
    }

    public boolean isComment() {
        return this.type == 0;
    }

    public boolean isEntity() {
        return this.type == 1;
    }

    public boolean isElement() {
        return this.type == 2;
    }

    public boolean isAttribute() {
        return this.type == 3;
    }

    public boolean isRoot() {
        return this.type == 4;
    }

    public boolean isElementSet() {
        return this.type == 5;
    }

    public boolean isElementRef() {
        return this.type == 6;
    }

    public void addNodeComment(String string) {
        this.comment = this.comment == null ? string : this.comment + "\n" + string;
    }

    public String getNodeComment() {
        return this.comment;
    }

    public void writeComment(PrintWriter printWriter) {
        if (this.comment != null) {
            printWriter.write(this.getDTDComment());
        }
    }

    protected String getDTDComment(String string) {
        if (string == null) {
            return "";
        }
        return "<!--" + string + "-->\n";
    }

    protected String getDTDComment() {
        return this.getDTDComment(this.comment);
    }

    public boolean isEmpty() {
        return this.children == null;
    }

    public void addDTDNode(DTDNode dTDNode) {
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.add(dTDNode);
        dTDNode.setDTDParentNode(this);
    }

    public void removeDTDNode(DTDNode dTDNode) {
        if (this.children != null) {
            this.children.remove(dTDNode);
        }
    }

    public int getDTDNodeCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public DTDNode getDTDNodeAt(int n) {
        if (this.children == null) {
            return null;
        }
        return (DTDNode)this.children.get(n);
    }

    public int getDTDNodeIndex(DTDNode dTDNode) {
        if (this.children == null) {
            return -1;
        }
        return this.children.indexOf(dTDNode);
    }

    public Enumeration getDTDNodes() {
        if (this.children == null) {
            return null;
        }
        return this.children.elements();
    }

    public void setDTDParentNode(DTDNode dTDNode) {
        this.parent = dTDNode;
    }

    public DTDNode getDTDParentNode() {
        return this.parent;
    }

    public Enumeration getDTDNodeForType(int n) {
        Vector<DTDNode> vector = new Vector<DTDNode>();
        for (int i = 0; i < this.getDTDNodeCount(); ++i) {
            DTDNode dTDNode = this.getDTDNodeAt(i);
            if (dTDNode.getNodeType() != n) continue;
            vector.add(dTDNode);
        }
        return vector.elements();
    }

    public Enumeration children() {
        return this.getDTDNodes();
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public TreeNode getChildAt(int n) {
        return this.getDTDNodeAt(n);
    }

    public int getChildCount() {
        return this.getDTDNodeCount();
    }

    public int getIndex(TreeNode treeNode) {
        return this.getDTDNodeIndex((DTDNode)treeNode);
    }

    public TreeNode getParent() {
        return this.getDTDParentNode();
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public void setFlagged() {
        this.flagged = true;
    }

    public boolean isFlagged() {
        return this.flagged;
    }
}

