/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import org.exist.dom.AVLTreeNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.util.FastQSort;
import org.exist.xquery.OrderSpec;
import org.exist.xquery.XPathException;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.AbstractSequence;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;

public class OrderedValueSequence
extends AbstractSequence {
    private OrderSpec[] orderSpecs;
    private Entry[] items = null;
    private int count = 0;
    private int itemType = 12;

    public OrderedValueSequence(OrderSpec[] orderSpecs, int size) {
        this.orderSpecs = orderSpecs;
        this.items = new Entry[size];
    }

    public SequenceIterator iterate() throws XPathException {
        return new OrderedValueSequenceIterator();
    }

    public SequenceIterator unorderedIterator() {
        return new OrderedValueSequenceIterator();
    }

    public int getItemCount() {
        return this.items == null ? 0 : this.count;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public boolean hasOne() {
        return this.hasOne;
    }

    public void add(Item item) throws XPathException {
        if (this.hasOne) {
            this.hasOne = false;
        }
        if (this.isEmpty) {
            this.hasOne = true;
        }
        this.isEmpty = false;
        if (this.count == 0 && this.items.length == 1) {
            this.items = new Entry[2];
        } else if (this.count == this.items.length) {
            Entry[] newItems = new Entry[this.count * 2];
            System.arraycopy(this.items, 0, newItems, 0, this.count);
            this.items = newItems;
        }
        this.items[this.count++] = new Entry(item);
        this.checkItemType(item.getType());
    }

    public void addAll(Sequence other) throws XPathException {
        if (other.hasOne()) {
            this.add(other.itemAt(0));
        } else if (!other.isEmpty()) {
            SequenceIterator i = other.iterate();
            while (i.hasNext()) {
                Item next = i.nextItem();
                if (next == null) continue;
                this.add(next);
            }
        }
    }

    public void sort() {
        FastQSort.sort(this.items, 0, this.count - 1);
    }

    public Item itemAt(int pos) {
        if (this.items != null && pos > -1 && pos < this.count) {
            return this.items[pos].item;
        }
        return null;
    }

    private void checkItemType(int type) {
        if (this.itemType == -1 || this.itemType == type) {
            return;
        }
        this.itemType = this.itemType == 12 ? type : -1;
    }

    public int getItemType() {
        return this.itemType;
    }

    public NodeSet toNodeSet() throws XPathException {
        if (this.isEmpty()) {
            return NodeSet.EMPTY_SET;
        }
        if (this.itemType != 12 && Type.subTypeOf(this.itemType, -1)) {
            AVLTreeNodeSet set = new AVLTreeNodeSet();
            for (int i = 0; i < this.items.length; ++i) {
                if (this.items[i] == null) continue;
                NodeValue v = (NodeValue)this.items[i].item;
                if (v.getImplementationType() != 1) {
                    set.add((NodeProxy)v);
                    continue;
                }
                set.add((NodeProxy)v);
            }
            return set;
        }
        throw new XPathException("Type error: the sequence cannot be converted into a node set. Item type is " + Type.getTypeName(this.itemType));
    }

    public void removeDuplicates() {
    }

    private class OrderedValueSequenceIterator
    implements SequenceIterator {
        int pos = 0;

        private OrderedValueSequenceIterator() {
        }

        public boolean hasNext() {
            return this.pos < OrderedValueSequence.this.count;
        }

        public Item nextItem() {
            if (this.pos < OrderedValueSequence.this.count) {
                return ((OrderedValueSequence)OrderedValueSequence.this).items[this.pos++].item;
            }
            return null;
        }
    }

    private class Entry
    implements Comparable {
        Item item;
        AtomicValue[] values;

        public Entry(Item item) throws XPathException {
            this.item = item;
            this.values = new AtomicValue[OrderedValueSequence.this.orderSpecs.length];
            for (int i = 0; i < OrderedValueSequence.this.orderSpecs.length; ++i) {
                Sequence seq = OrderedValueSequence.this.orderSpecs[i].getSortExpression().eval(null);
                this.values[i] = AtomicValue.EMPTY_VALUE;
                if (seq.hasOne()) {
                    this.values[i] = seq.itemAt(0).atomize();
                    continue;
                }
                if (!seq.hasMany()) continue;
                throw new XPathException("expected a single value for order expression " + ExpressionDumper.dump(OrderedValueSequence.this.orderSpecs[i].getSortExpression()) + " ; found: " + seq.getItemCount());
            }
        }

        public int compareTo(Object o) {
            Entry other = (Entry)o;
            int cmp = 0;
            for (int i = 0; i < this.values.length; ++i) {
                try {
                    AtomicValue a = this.values[i];
                    AtomicValue b = other.values[i];
                    cmp = a.isEmpty() || Type.subTypeOf(a.getType(), 30) && ((NumericValue)a).isNaN() ? ((OrderedValueSequence.this.orderSpecs[i].getModifiers() & 4) != 0 ? -1 : 1) : (b.isEmpty() || Type.subTypeOf(b.getType(), 30) && ((NumericValue)b).isNaN() ? ((OrderedValueSequence.this.orderSpecs[i].getModifiers() & 4) != 0 ? 1 : -1) : (a == AtomicValue.EMPTY_VALUE && b != AtomicValue.EMPTY_VALUE ? ((OrderedValueSequence.this.orderSpecs[i].getModifiers() & 4) != 0 ? -1 : 1) : (b == AtomicValue.EMPTY_VALUE && a != AtomicValue.EMPTY_VALUE ? ((OrderedValueSequence.this.orderSpecs[i].getModifiers() & 4) != 0 ? 1 : -1) : a.compareTo(OrderedValueSequence.this.orderSpecs[i].getCollator(), b))));
                    if ((OrderedValueSequence.this.orderSpecs[i].getModifiers() & 1) != 0) {
                        cmp *= -1;
                    }
                    if (cmp == 0) continue;
                    break;
                }
                catch (XPathException e) {
                    // empty catch block
                }
            }
            return cmp;
        }
    }
}

