/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.text.Collator;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Type;

public abstract class BinaryValue
extends AtomicValue {
    protected byte[] data;

    public BinaryValue() {
    }

    public BinaryValue(byte[] data) {
        this.data = data;
    }

    public byte[] getBinaryData() {
        return this.data;
    }

    public boolean compareTo(Collator collator, int operator, AtomicValue other) throws XPathException {
        if (other.getType() == 27 || other.getType() == 26) {
            int value = this.compareTo((BinaryValue)other);
            switch (operator) {
                case 4: {
                    return value == 0;
                }
                case 5: {
                    return value != 0;
                }
                case 1: {
                    return value > 0;
                }
                case 2: {
                    return value >= 0;
                }
                case 0: {
                    return value < 0;
                }
                case 3: {
                    return value <= 0;
                }
            }
            throw new XPathException("Type error: cannot apply operator to numeric value");
        }
        throw new XPathException("Cannot compare value of type xs:hexBinary with " + Type.getTypeName(other.getType()));
    }

    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 27 || other.getType() == 26) {
            return this.compareTo((BinaryValue)other);
        }
        throw new XPathException("Cannot compare value of type xs:hexBinary with " + Type.getTypeName(other.getType()));
    }

    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("Cannot compare values of type " + Type.getTypeName(this.getType()));
    }

    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("Cannot compare values of type " + Type.getTypeName(this.getType()));
    }

    public int conversionPreference(Class javaClass) {
        if (javaClass.isArray() && javaClass.isInstance(Byte.class)) {
            return 0;
        }
        return Integer.MAX_VALUE;
    }

    protected int compareTo(BinaryValue otherValue) {
        int a1len = this.data.length;
        byte[] other = otherValue.data;
        int a2len = other.length;
        int limit = a1len <= a2len ? a1len : a2len;
        for (int i = 0; i < limit; ++i) {
            byte b1 = this.data[i];
            byte b2 = other[i];
            if (b1 == b2) continue;
            return (b1 & 0xFF) - (b2 & 0xFF);
        }
        return a1len - a2len;
    }
}

