/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.validation;

import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.exist.dom.QName;
import org.exist.memtree.MemTreeBuilder;
import org.exist.memtree.NodeImpl;
import org.exist.storage.BrokerPool;
import org.exist.util.Configuration;
import org.exist.validation.GrammarPool;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.ValueSequence;
import org.xml.sax.helpers.AttributesImpl;

public class GrammarTooling
extends BasicFunction {
    private static final String TYPE_DTD = "http://www.w3.org/TR/REC-xml";
    private static final String TYPE_XSD = "http://www.w3.org/2001/XMLSchema";
    private final Configuration config;
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("clear-grammar-cache", "http://exist-db.org/xquery/validation", "validation"), "Remove all cached grammers.", null, new SequenceType(31, 2)), new FunctionSignature(new QName("show-grammar-cache", "http://exist-db.org/xquery/validation", "validation"), "Show all cached grammars.", null, new SequenceType(-1, 2))};

    public GrammarTooling(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
        BrokerPool brokerPool = context.getBroker().getBrokerPool();
        this.config = brokerPool.getConfiguration();
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        GrammarPool grammarpool = (GrammarPool)this.config.getProperty("validation.grammar_pool");
        if (this.isCalledAs("clear-grammar-cache")) {
            ValueSequence result = new ValueSequence();
            int before = this.countTotalNumberOfGrammar(grammarpool);
            LOG.debug((Object)("Clearing " + before + " grammars"));
            this.clearGrammarPool(grammarpool);
            int after = this.countTotalNumberOfGrammar(grammarpool);
            LOG.debug((Object)("Remained " + after + " grammars"));
            int delta = before - after;
            result.add(new IntegerValue(delta));
            return result;
        }
        if (this.isCalledAs("show-grammar-cache")) {
            MemTreeBuilder builder = this.context.getDocumentBuilder();
            NodeImpl result = this.writeReport(grammarpool, builder);
            return result;
        }
        LOG.error((Object)"function not found error");
        throw new XPathException("function not found");
    }

    private int countTotalNumberOfGrammar(GrammarPool grammarpool) {
        return grammarpool.retrieveInitialGrammarSet(TYPE_XSD).length + grammarpool.retrieveInitialGrammarSet(TYPE_DTD).length;
    }

    private void clearGrammarPool(GrammarPool grammarpool) {
        grammarpool.clear();
    }

    private NodeImpl writeReport(GrammarPool grammarpool, MemTreeBuilder builder) {
        int nodeNr = builder.startElement("", "report", "report", null);
        Grammar[] xsds = grammarpool.retrieveInitialGrammarSet(TYPE_XSD);
        for (int i = 0; i < xsds.length; ++i) {
            this.writeGrammar(xsds[i], builder);
        }
        Grammar[] dtds = grammarpool.retrieveInitialGrammarSet(TYPE_DTD);
        for (int i = 0; i < dtds.length; ++i) {
            this.writeGrammar(dtds[i], builder);
        }
        builder.endElement();
        return builder.getDocument().getNode(nodeNr);
    }

    private void writeGrammar(Grammar grammar, MemTreeBuilder builder) {
        String expandedSystemId;
        String literalSystemId;
        String baseSystemId;
        String publicId;
        XMLGrammarDescription xgd = grammar.getGrammarDescription();
        AttributesImpl attribs = new AttributesImpl();
        attribs.addAttribute("", "type", "type", "CDATA", xgd.getGrammarType());
        builder.startElement("", "grammar", "grammar", attribs);
        String namespace = xgd.getNamespace();
        if (namespace != null) {
            builder.startElement("", "Namespace", "Namespace", null);
            builder.characters(namespace);
            builder.endElement();
        }
        if ((publicId = xgd.getPublicId()) != null) {
            builder.startElement("", "PublicId", "PublicId", null);
            builder.characters(publicId);
            builder.endElement();
        }
        if ((baseSystemId = xgd.getBaseSystemId()) != null) {
            builder.startElement("", "BaseSystemId", "BaseSystemId", null);
            builder.characters(baseSystemId);
            builder.endElement();
        }
        if ((literalSystemId = xgd.getLiteralSystemId()) != null) {
            builder.startElement("", "LiteralSystemId", "LiteralSystemId", null);
            builder.characters(literalSystemId);
            builder.endElement();
        }
        if ((expandedSystemId = xgd.getExpandedSystemId()) != null) {
            builder.startElement("", "ExpandedSystemId", "ExpandedSystemId", null);
            builder.characters(expandedSystemId);
            builder.endElement();
        }
        builder.endElement();
        attribs.clear();
    }
}

