/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunItemAt
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("item-at", "http://www.w3.org/2005/xpath-functions"), "Returns the item in the first argument sequence that is located at the position specified by the second argument. Deprecated. Use $x[1] instead.", new SequenceType[]{new SequenceType(11, 7), new SequenceType(31, 2)}, new SequenceType(23, 3));

    public FunItemAt(XQueryContext context) {
        super(context, signature);
    }

    public int getDependencies() {
        return 1;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        Sequence seq = this.getArgument(0).eval(contextSequence, contextItem);
        IntegerValue posArg = (IntegerValue)this.getArgument(1).eval(contextSequence, contextItem).convertTo(31);
        long pos = posArg.getValue();
        if (pos < 1L || pos > (long)seq.getItemCount()) {
            throw new XPathException("Invalid position: " + pos);
        }
        Item item = seq.itemAt((int)pos - 1);
        if (item == null) {
            LOG.debug((Object)("Item is null: " + seq.getClass().getName() + "; len = " + seq.getItemCount()));
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            result = item.toSequence();
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

