/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.util.StringTokenizer;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.NodeSetIterator;
import org.exist.dom.QName;
import org.exist.util.XMLChar;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class FunId
extends Function {
    public static final FunctionSignature[] signature = new FunctionSignature[]{new FunctionSignature(new QName("id", "http://www.w3.org/2005/xpath-functions"), "Returns the sequence of element nodes that have an ID value matching the value of one or more of the IDREF values supplied in $a. If none is matching or $a is the empty sequence, returns the empty sequence.", new SequenceType[]{new SequenceType(22, 7)}, new SequenceType(1, 7)), new FunctionSignature(new QName("id", "http://www.w3.org/2005/xpath-functions"), "Returns the sequence of element nodes that have an ID value matching the value of one or more of the IDREF values supplied in $a. If none is matching or $a is the empty sequence, returns the empty sequence.", new SequenceType[]{new SequenceType(22, 7), new SequenceType(-1, 2)}, new SequenceType(1, 7))};

    public FunId(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        Expression arg;
        Sequence idval;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (this.getArgumentCount() < 1) {
            throw new XPathException("function id requires one argument");
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if ((idval = (arg = this.getArgument(0)).eval(contextSequence)).isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            DocumentSet docs;
            result = new ExtArrayNodeSet();
            if (this.getArgumentCount() == 2) {
                Sequence nodes = this.getArgument(1).eval(contextSequence);
                if (nodes.isEmpty()) {
                    throw new XPathException(this.getASTNode(), "XPDY0002: no node or context item for fn:id");
                }
                if (!Type.subTypeOf(nodes.itemAt(0).getType(), -1)) {
                    throw new XPathException(this.getASTNode(), "XPTY0004: fn:id() argument is not a node");
                }
                NodeValue node = (NodeValue)nodes.itemAt(0);
                if (node.getImplementationType() == 0) {
                    throw new XPathException(this.getASTNode(), "FODC0001: supplied node is not from a persistent document");
                }
                docs = new DocumentSet();
                docs.add(((NodeProxy)node).getDocument());
            } else {
                if (contextSequence == null) {
                    throw new XPathException(this.getASTNode(), "XPDY0002: no context item specified");
                }
                if (!Type.subTypeOf(contextSequence.getItemType(), -1)) {
                    throw new XPathException(this.getASTNode(), "XPTY0004: context item is not a node");
                }
                docs = contextSequence.toNodeSet().getDocumentSet();
            }
            SequenceIterator i = idval.iterate();
            while (i.hasNext()) {
                String nextId = i.nextItem().getStringValue();
                if (nextId.length() == 0) continue;
                if (nextId.indexOf(" ") != -1) {
                    StringTokenizer tok = new StringTokenizer(nextId, " ");
                    while (tok.hasMoreTokens()) {
                        nextId = tok.nextToken();
                        if (!XMLChar.isValidNCName(nextId)) continue;
                        QName id = new QName(nextId, "", null);
                        this.getId((NodeSet)result, docs, id);
                    }
                    continue;
                }
                if (!XMLChar.isValidNCName(nextId)) continue;
                QName id = new QName(nextId, "", null);
                this.getId((NodeSet)result, docs, id);
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    private void getId(NodeSet result, DocumentSet docs, QName id) {
        NodeSet attribs = this.context.getBroker().getElementIndex().findElementsByTagName((byte)2, docs, id, null);
        NodeSetIterator i = attribs.iterator();
        while (i.hasNext()) {
            NodeProxy n = (NodeProxy)i.next();
            NodeProxy p = new NodeProxy(n.getDocument(), n.getNodeId().getParentId(), 1);
            result.add(p);
        }
    }
}

