/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import com.sun.xacml.ctx.RequestCtx;
import java.io.Writer;
import java.util.List;
import org.exist.dom.DocumentSet;
import org.exist.dom.QName;
import org.exist.security.PermissionDeniedException;
import org.exist.security.xacml.ExistPDP;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.PathExpr;
import org.exist.xquery.Predicate;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryAST;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class InternalFunctionCall
extends Function {
    private final Function function;

    public InternalFunctionCall(Function f) {
        super(f.getContext(), f.getSignature());
        this.function = f;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        QName functionName = this.function.getName();
        try {
            RequestCtx request;
            ExistPDP pdp = this.getContext().getPDP();
            if (pdp != null && (request = pdp.getRequestHelper().createFunctionRequest(this.context, null, functionName)) != null) {
                pdp.evaluate(request);
            }
        }
        catch (PermissionDeniedException pde) {
            throw new XPathException(this.function.getASTNode(), "Access to function '" + functionName + "'  denied.", pde);
        }
        try {
            return this.function.eval(contextSequence, contextItem);
        }
        catch (XPathException e) {
            if (e.getLine() == 0) {
                e.setASTNode(this.getASTNode());
            }
            throw e;
        }
    }

    public int getArgumentCount() {
        return this.function.getArgumentCount();
    }

    public QName getName() {
        return this.function.getName();
    }

    public int returnsType() {
        return this.function.returnsType();
    }

    public int getCardinality() {
        return this.function.getCardinality();
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.function.analyze(contextInfo);
    }

    public void setParent(Expression parent) {
        this.function.setParent(parent);
    }

    public Expression getParent() {
        return this.function.getParent();
    }

    public XQueryContext getContext() {
        return this.function.getContext();
    }

    public void setASTNode(XQueryAST ast) {
        this.function.setASTNode(ast);
    }

    public XQueryAST getASTNode() {
        return this.function.getASTNode();
    }

    public void add(Expression s) {
        this.function.add(s);
    }

    public void add(PathExpr path) {
        this.function.add(path);
    }

    public void addPath(PathExpr path) {
        this.function.addPath(path);
    }

    public void addPredicate(Predicate pred) {
        this.function.addPredicate(pred);
    }

    public void dump(ExpressionDumper dumper) {
        this.function.dump(dumper);
    }

    public void dump(Writer writer) {
        this.function.dump(writer);
    }

    public Expression getArgument(int pos) {
        return this.function.getArgument(pos);
    }

    public Sequence[] getArguments(Sequence contextSequence, Item contextItem) throws XPathException {
        return this.function.getArguments(contextSequence, contextItem);
    }

    public DocumentSet getContextDocSet() {
        return this.function.getContextDocSet();
    }

    public int getDependencies() {
        return this.function.getDependencies();
    }

    public DocumentSet getDocumentSet() {
        return this.function.getDocumentSet();
    }

    public Expression getExpression(int pos) {
        return this.function.getExpression(pos);
    }

    public Expression getLastExpression() {
        return this.function.getLastExpression();
    }

    public int getLength() {
        return this.function.getLength();
    }

    public String getLiteralValue() {
        return this.function.getLiteralValue();
    }

    public FunctionSignature getSignature() {
        return this.function.getSignature();
    }

    public boolean isCalledAs(String localName) {
        return this.function.isCalledAs(localName);
    }

    public boolean isValid() {
        return this.function.isValid();
    }

    public void replaceLastExpression(Expression s) {
        this.function.replaceLastExpression(s);
    }

    public void reset() {
        this.function.reset();
    }

    public void resetState(boolean postOptimization) {
        this.function.resetState(postOptimization);
    }

    public void setArguments(List arguments) throws XPathException {
        this.function.setArguments(arguments);
    }

    public void setContext(XQueryContext context) {
        this.function.setContext(context);
    }

    public void setContextDocSet(DocumentSet contextSet) {
        this.function.setContextDocSet(contextSet);
    }

    public String toString() {
        return this.function.toString();
    }

    public void accept(ExpressionVisitor visitor) {
        this.function.accept(visitor);
    }
}

