/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.DocumentSet;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Cardinality;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.Error;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class DynamicCardinalityCheck
extends AbstractExpression {
    private final Expression expression;
    private final int requiredCardinality;
    private Error error;

    public DynamicCardinalityCheck(XQueryContext context, int requiredCardinality, Expression expr, Error error) {
        super(context);
        this.requiredCardinality = requiredCardinality;
        this.expression = expr;
        this.error = error;
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.expression.analyze(contextInfo);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence seq;
        int actualCardinality;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (!Cardinality.checkCardinality(this.requiredCardinality, actualCardinality = (seq = this.expression.eval(contextSequence, contextItem)).isEmpty() ? 1 : (seq.hasMany() ? 4 : 2))) {
            this.error.addArgs(ExpressionDumper.dump(this.expression), Cardinality.getDescription(this.requiredCardinality), new Integer(seq.getItemCount()));
            throw new XPathException(this.getASTNode(), this.error.toString());
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", seq);
        }
        return seq;
    }

    public void dump(ExpressionDumper dumper) {
        if (dumper.verbosity() > 1) {
            dumper.display("dynamic-cardinality-check");
            dumper.display("(");
            dumper.display("\"" + Cardinality.getDescription(this.requiredCardinality) + "\"");
            dumper.display(", ");
        }
        this.expression.dump(dumper);
        if (dumper.verbosity() > 1) {
            dumper.display(")");
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("dynamic-cardinality-check(");
        result.append("\"" + Cardinality.getDescription(this.requiredCardinality) + "\"");
        result.append(", ");
        result.append(this.expression.toString());
        result.append(")");
        return result.toString();
    }

    public int returnsType() {
        return this.expression.returnsType();
    }

    public int getDependencies() {
        return this.expression.getDependencies();
    }

    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        this.expression.setContextDocSet(contextSet);
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.expression.resetState(postOptimization);
    }

    public void accept(ExpressionVisitor visitor) {
        this.expression.accept(visitor);
    }
}

