/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.List;
import java.util.Stack;
import org.exist.xquery.BasicExpressionVisitor;
import org.exist.xquery.ConditionalExpression;
import org.exist.xquery.Expression;
import org.exist.xquery.ForExpr;
import org.exist.xquery.Function;
import org.exist.xquery.LetExpr;
import org.exist.xquery.LocationStep;
import org.exist.xquery.PathExpr;
import org.exist.xquery.Predicate;
import org.exist.xquery.UserDefinedFunction;

public class DefaultExpressionVisitor
extends BasicExpressionVisitor {
    private Stack functionStack = new Stack();

    public void visitPathExpr(PathExpr expression) {
        for (int i = 0; i < expression.getLength(); ++i) {
            Expression next = expression.getExpression(i);
            next.accept(this);
        }
    }

    public void visitUserFunction(UserDefinedFunction function) {
        if (this.functionStack.contains(function)) {
            return;
        }
        this.functionStack.push(function);
        function.getFunctionBody().accept(this);
        this.functionStack.pop();
    }

    public void visitBuiltinFunction(Function function) {
        for (int i = 0; i < function.getArgumentCount(); ++i) {
            Expression arg = function.getArgument(i);
            arg.accept(this);
        }
    }

    public void visitForExpression(ForExpr forExpr) {
        forExpr.getInputSequence().accept(this);
        Expression where = forExpr.getWhereExpression();
        if (where != null) {
            where.accept(this);
        }
        forExpr.getReturnExpression().accept(this);
    }

    public void visitLetExpression(LetExpr letExpr) {
        letExpr.getInputSequence().accept(this);
        Expression where = letExpr.getWhereExpression();
        if (where != null) {
            where.accept(this);
        }
        letExpr.getReturnExpression().accept(this);
    }

    public void visitConditional(ConditionalExpression conditional) {
        conditional.getTestExpr().accept(this);
        conditional.getThenExpr().accept(this);
        conditional.getElseExpr().accept(this);
    }

    public void visitLocationStep(LocationStep locationStep) {
        List predicates = locationStep.getPredicates();
        for (int i = 0; i < predicates.size(); ++i) {
            Predicate pred = (Predicate)predicates.get(i);
            pred.accept(this);
        }
    }

    public void visitPredicate(Predicate predicate) {
        predicate.getExpression(0).accept(this);
    }
}

