/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmlrpc;

import java.util.Date;
import org.apache.log4j.Logger;
import org.exist.xmlrpc.QueryResult;

public class QueryResultCache {
    public static final int TIMEOUT = 180000;
    private static final int INITIAL_SIZE = 254;
    public QueryResult[] results = new QueryResult[254];
    private static final Logger LOG = Logger.getLogger((Class)QueryResultCache.class);

    public int add(QueryResult qr) {
        for (int i = 0; i < this.results.length; ++i) {
            if (this.results[i] != null) continue;
            this.results[i] = qr;
            return i;
        }
        QueryResult[] temp = new QueryResult[this.results.length * 3 / 2];
        System.arraycopy(this.results, 0, temp, 0, this.results.length);
        int pos = this.results.length;
        temp[pos] = qr;
        this.results = temp;
        return pos;
    }

    public QueryResult get(int pos) {
        if (pos < 0 || pos >= this.results.length) {
            return null;
        }
        return this.results[pos];
    }

    public void remove(int pos) {
        if (pos > -1 && pos < this.results.length) {
            this.results[pos] = null;
        }
    }

    public void checkTimestamps() {
        long now = System.currentTimeMillis();
        for (int i = 0; i < this.results.length; ++i) {
            QueryResult result = this.results[i];
            if (result == null || now - result.getTimestamp() <= 180000L) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing result set " + new Date(result.getTimestamp()).toString()));
            }
            this.results[i] = null;
        }
    }
}

