/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import org.exist.util.CharArrayPool;
import org.exist.util.UTF8;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public final class XMLString
implements CharSequence,
Comparable {
    public static final int SUPPRESS_NONE = 0;
    public static final int SUPPRESS_LEADING_WS = 1;
    public static final int SUPPRESS_TRAILING_WS = 2;
    public static final int SUPPRESS_BOTH = 3;
    public static final int DEFAULT_CAPACITY = 16;
    private char[] value_ = null;
    private int start_ = 0;
    private int length_ = 0;

    public XMLString() {
        this.value_ = CharArrayPool.getCharArray(16);
    }

    public XMLString(int capacity) {
        this.value_ = CharArrayPool.getCharArray(capacity);
    }

    public XMLString(char[] ch) {
        this.value_ = CharArrayPool.getCharArray(ch.length);
        System.arraycopy(ch, 0, this.value_, 0, ch.length);
        this.length_ = ch.length;
    }

    public XMLString(char[] ch, int start, int length) {
        this.value_ = CharArrayPool.getCharArray(length);
        System.arraycopy(ch, start, this.value_, 0, length);
        this.length_ = length;
    }

    public XMLString(XMLString other) {
        this.value_ = CharArrayPool.getCharArray(other.length_);
        System.arraycopy(other.value_, other.start_, this.value_, 0, other.length_);
        this.length_ = other.length_;
    }

    public final XMLString append(String str) {
        this.append(str.toCharArray());
        return this;
    }

    public final XMLString append(char[] ch) {
        this.append(ch, 0, ch.length);
        return this;
    }

    public final XMLString append(char[] ch, int offset, int len) {
        this.ensureCapacity(this.length_ + len);
        System.arraycopy(ch, offset, this.value_, this.length_, len);
        this.length_ += len;
        return this;
    }

    public final XMLString append(XMLString other) {
        this.ensureCapacity(this.length_ + other.length_);
        System.arraycopy(other.value_, other.start_, this.value_, this.length_, other.length_);
        this.length_ += other.length_;
        return this;
    }

    public final XMLString append(char ch) {
        if (this.value_.length < this.length_ + 2) {
            this.ensureCapacity(this.length_ + 1);
        }
        this.value_[this.length_++] = ch;
        return this;
    }

    public final void setData(char[] ch, int offset, int len) {
        this.length_ = 0;
        this.start_ = 0;
        this.append(ch, offset, len);
    }

    public final XMLString normalize(int mode) {
        if (this.length_ == 0) {
            return this;
        }
        if ((mode & 1) != 0) {
            while (this.length_ > 0 && XMLString.isWhiteSpace(this.value_[this.start_])) {
                --this.length_;
                if (this.length_ <= 0) continue;
                ++this.start_;
            }
        }
        if ((mode & 2) != 0) {
            while (this.length_ > 0 && XMLString.isWhiteSpace(this.value_[this.start_ + this.length_ - 1])) {
                --this.length_;
            }
        }
        return this;
    }

    public final boolean isWhitespaceOnly() {
        int i;
        if (this.length_ == 0) {
            return true;
        }
        for (i = 0; i < this.length_ && XMLString.isWhiteSpace(this.value_[this.start_ + i]); ++i) {
        }
        return i == this.length_;
    }

    public final String toString() {
        if (this.value_ == null) {
            return "null";
        }
        return new String(this.value_, this.start_, this.length_);
    }

    public final int length() {
        return this.length_;
    }

    public final int startOffset() {
        return this.start_;
    }

    public final String substring(int start, int count) {
        if (start < 0 || count < 0 || start >= this.length_ || start + count > this.length_) {
            throw new StringIndexOutOfBoundsException();
        }
        return new String(this.value_, this.start_ + start, count);
    }

    public final XMLString delete(int start, int count) {
        System.arraycopy(this.value_, start + count + this.start_, this.value_, start, this.length_ - (start + count));
        this.start_ = 0;
        this.length_ -= count;
        return this;
    }

    public final XMLString insert(int offset, String data) {
        this.ensureCapacity(this.length_ + data.length());
        System.arraycopy(this.value_, offset, this.value_, offset + data.length(), this.length_ - offset);
        System.arraycopy(data.toCharArray(), 0, this.value_, offset, data.length());
        this.length_ += data.length();
        return this;
    }

    public final XMLString replace(int offset, int count, String data) {
        if (offset < 0 || count < 0 || offset >= this.length_ || offset + count > this.length_) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(data.toCharArray(), 0, this.value_, this.start_ + offset, count);
        return this;
    }

    public final char charAt(int pos) {
        return this.value_[this.start_ + pos];
    }

    public final void reset() {
        CharArrayPool.releaseCharArray(this.value_);
        this.value_ = null;
        this.start_ = 0;
        this.length_ = 0;
    }

    public final void reuse() {
        this.start_ = 0;
        this.length_ = 0;
    }

    private void ensureCapacity(int capacity) {
        if (this.value_ == null) {
            this.value_ = CharArrayPool.getCharArray(capacity);
        } else if (this.value_.length - this.start_ < capacity) {
            int newCapacity = (this.length_ + 1) * 2;
            if (newCapacity < capacity) {
                newCapacity = capacity;
            }
            char[] temp = CharArrayPool.getCharArray(newCapacity);
            System.arraycopy(this.value_, this.start_, temp, 0, this.length_);
            CharArrayPool.releaseCharArray(this.value_);
            this.value_ = temp;
            this.start_ = 0;
        }
    }

    private static boolean isWhiteSpace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n';
    }

    public final void release() {
        CharArrayPool.releaseCharArray(this.value_);
        this.value_ = null;
    }

    public final CharSequence subSequence(int start, int end) {
        return new XMLString(this.value_, this.start_ + start, end - start);
    }

    public final XMLString transformToLower() {
        int end = this.start_ + this.length_;
        for (int i = this.start_; i < end; ++i) {
            this.value_[i] = Character.toLowerCase(this.value_[i]);
        }
        return this;
    }

    public final int UTF8Size() {
        return UTF8.encoded(this.value_, this.start_, this.length_);
    }

    public final byte[] UTF8Encode(byte[] b, int offset) {
        return UTF8.encode(this.value_, this.start_, this.length_, b, offset);
    }

    public final void toSAX(ContentHandler ch) throws SAXException {
        ch.characters(this.value_, this.start_, this.length_);
    }

    public final int compareTo(Object o) {
        CharSequence cs = (CharSequence)o;
        for (int i = 0; i < this.length_ && i < cs.length(); ++i) {
            if (this.value_[this.start_ + i] < cs.charAt(i)) {
                return -1;
            }
            if (this.value_[this.start_ + i] <= cs.charAt(i)) continue;
            return 1;
        }
        if (this.length_ < cs.length()) {
            return -1;
        }
        if (this.length_ > cs.length()) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof XMLString) {
            XMLString anotherString = (XMLString)anObject;
            if (this.length_ == anotherString.length_) {
                int n = this.length_;
                char[] v1 = this.value_;
                char[] v2 = anotherString.value_;
                int i = this.start_;
                int j = anotherString.start_;
                while (n-- != 0) {
                    if (v1[i++] == v2[j++]) continue;
                    return false;
                }
                return true;
            }
        } else {
            String anotherString = anObject.toString();
            if (this.length_ == anotherString.length()) {
                int j = this.start_;
                for (int i = 0; i < this.length_; ++i) {
                    if (this.value_[j++] == anotherString.charAt(i)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int off = this.start_;
        int h = 0;
        for (int i = 0; i < this.length_; ++i) {
            h = 31 * h + this.value_[off++];
        }
        return h;
    }
}

