/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.index;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.index.AbstractBFileLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class OverflowCreatePageLoggable
extends AbstractBFileLoggable {
    protected long newPage;
    protected long prevPage;

    public OverflowCreatePageLoggable(Txn transaction, byte fileId, long newPage, long prevPage) {
        super((byte)56, fileId, transaction);
        this.newPage = newPage;
        this.prevPage = prevPage;
    }

    public OverflowCreatePageLoggable(DBBroker broker, long transactionId) {
        super(broker, transactionId);
    }

    public void write(ByteBuffer out) {
        super.write(out);
        out.putInt((int)this.newPage);
        out.putInt((int)this.prevPage);
    }

    public void read(ByteBuffer in) {
        super.read(in);
        this.newPage = in.getInt();
        this.prevPage = in.getInt();
    }

    public int getLogSize() {
        return super.getLogSize() + 8;
    }

    public void redo() throws LogException {
        this.getIndexFile().redoCreateOverflowPage(this);
    }

    public void undo() throws LogException {
        this.getIndexFile().undoCreateOverflowPage(this);
    }

    public String dump() {
        return super.dump() + " - create new overflow page " + this.newPage;
    }
}

