/*
 * Decompiled with CFR 0.152.
 */
package org.exist.scheduler;

import java.util.Date;
import org.quartz.CronTrigger;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class ScheduledJobInfo {
    private Scheduler scheduler = null;
    private Trigger trigger = null;
    public static final int TRIGGER_STATE_ERROR = -1;
    public static final int TRIGGER_STATE_NONE = 0;
    public static final int TRIGGER_STATE_NORMAL = 1;
    public static final int TRIGGER_STATE_PAUSED = 2;
    public static final int TRIGGER_STATE_BLOCKED = 3;
    public static final int TRIGGER_STATE_COMPLETE = 4;

    public ScheduledJobInfo(Scheduler scheduler, Trigger trigger) {
        this.scheduler = scheduler;
        this.trigger = trigger;
    }

    public String getName() {
        return this.trigger.getJobName();
    }

    public String getGroup() {
        return this.trigger.getJobGroup();
    }

    public String getTriggerName() {
        return this.trigger.getName();
    }

    public Date getStartTime() {
        return this.trigger.getStartTime();
    }

    public Date getEndTime() {
        return this.trigger.getEndTime();
    }

    public Date getPreviousFireTime() {
        return this.trigger.getPreviousFireTime();
    }

    public Date getNextFireTime() {
        return this.trigger.getNextFireTime();
    }

    public Date getFinalFireTime() {
        return this.trigger.getFinalFireTime();
    }

    public String getTriggerExpression() {
        if (this.trigger instanceof CronTrigger) {
            return ((CronTrigger)this.trigger).getCronExpression();
        }
        if (this.trigger instanceof SimpleTrigger) {
            return String.valueOf(((SimpleTrigger)this.trigger).getRepeatInterval());
        }
        return null;
    }

    public int getTriggerState() {
        try {
            switch (this.scheduler.getTriggerState(this.trigger.getName(), this.trigger.getGroup())) {
                case 3: {
                    return -1;
                }
                case -1: {
                    return 0;
                }
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 4: {
                    return 3;
                }
                case 2: {
                    return 4;
                }
            }
            return -1;
        }
        catch (SchedulerException se) {
            return -1;
        }
    }
}

