/*
 * Decompiled with CFR 0.152.
 */
package org.exist.protocolhandler.xmlrpc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClient;
import org.exist.protocolhandler.xmldb.XmldbURL;
import org.exist.storage.io.ExistIOException;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;

public class XmlrpcUpload {
    private static final Logger LOG = Logger.getLogger((Class)XmlrpcUpload.class);

    public void stream(XmldbURL xmldbURL, InputStream is) throws IOException {
        block11: {
            LOG.debug((Object)"Begin document upload");
            try {
                int len;
                XmlRpc.setEncoding((String)"UTF-8");
                XmlRpcClient xmlrpc = new XmlRpcClient(xmldbURL.getXmlRpcURL());
                if (xmldbURL.hasUserInfo()) {
                    xmlrpc.setBasicAuthentication(xmldbURL.getUsername(), xmldbURL.getPassword());
                }
                String contentType = MimeType.BINARY_TYPE.getName();
                MimeType mime = MimeTable.getInstance().getContentTypeFor(xmldbURL.getDocumentName());
                if (mime != null) {
                    contentType = mime.getName();
                }
                Vector<Object> params = new Vector<Object>();
                String handle = null;
                byte[] buf = new byte[4096];
                while ((len = is.read(buf)) > 0) {
                    params.clear();
                    if (handle != null) {
                        params.addElement(handle);
                    }
                    params.addElement(buf);
                    params.addElement(new Integer(len));
                    handle = (String)xmlrpc.execute("upload", params);
                }
                params.clear();
                params.addElement(handle);
                params.addElement(xmldbURL.getCollectionPath());
                params.addElement(true);
                params.addElement(contentType);
                Boolean result = (Boolean)xmlrpc.execute("parseLocal", params);
                if (result.booleanValue()) {
                    LOG.debug((Object)"Document stored.");
                    break block11;
                }
                LOG.debug((Object)"Could not store document.");
                throw new ExistIOException("Could not store document.");
            }
            catch (IOException ex) {
                LOG.debug((Object)ex);
                throw ex;
            }
            catch (Exception ex) {
                LOG.debug((Object)ex);
                throw new ExistIOException(ex.getMessage(), ex);
            }
            finally {
                LOG.debug((Object)"Finished document upload");
            }
        }
    }
}

