/*
 * Decompiled with CFR 0.152.
 */
package org.exist.protocolhandler.xmlrpc;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.exist.protocolhandler.xmldb.XmldbURL;
import org.exist.protocolhandler.xmlrpc.XmlrpcUploadThread;
import org.exist.storage.io.BlockingInputStream;
import org.exist.storage.io.BlockingOutputStream;

public class XmlrpcOutputStream
extends OutputStream {
    private static final Logger logger = Logger.getLogger((Class)XmlrpcOutputStream.class);
    private BlockingInputStream bis;
    private BlockingOutputStream bos;
    private XmlrpcUploadThread rt;

    public XmlrpcOutputStream(XmldbURL xmldbURL) {
        logger.debug((Object)"Initializing XmlrpcOutputStream");
        this.bis = new BlockingInputStream();
        this.bos = this.bis.getOutputStream();
        this.rt = new XmlrpcUploadThread(xmldbURL, this.bis);
        this.rt.start();
        logger.debug((Object)"Initializing XmlrpcOutputStream done");
    }

    public void write(int b) throws IOException {
        this.bos.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.bos.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.bos.write(b, off, len);
    }

    public void close() throws IOException {
        this.bos.close();
    }

    public void flush() throws IOException {
        this.bos.flush();
    }
}

