/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.webdav.methods;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.DocumentImpl;
import org.exist.http.webdav.methods.AbstractWebDAVMethod;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.TransactionException;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xmldb.XmldbURI;

public class Move
extends AbstractWebDAVMethod {
    public Move(BrokerPool pool) {
        super(pool);
    }

    public void process(User user, HttpServletRequest request, HttpServletResponse response, XmldbURI path) throws ServletException, IOException {
        DBBroker broker = null;
        Collection collection = null;
        DocumentImpl resource = null;
        try {
            URI uri;
            XmldbURI destPath;
            block21: {
                broker = this.pool.get(user);
                collection = broker.openCollection(path, 1);
                if (collection == null) {
                    XmldbURI docUri = path.lastSegment();
                    XmldbURI collUri = path.removeLastSegment();
                    collection = broker.openCollection(collUri, 1);
                    if (collection == null) {
                        LOG.debug((Object)("No resource or collection found for path: " + path));
                        response.sendError(404, "No resource or collection found");
                        return;
                    }
                    resource = collection.getDocumentWithLock(broker, docUri, 1);
                    if (resource == null) {
                        LOG.debug((Object)("No resource found for path: " + path));
                        response.sendError(404, "No resource or collection found");
                        return;
                    }
                }
                String destination = request.getHeader("Destination");
                destPath = null;
                uri = new URI(destination);
                String host = uri.getHost();
                int port = uri.getPort();
                if (host.equals(request.getServerName()) && port == request.getServerPort()) break block21;
                response.sendError(501, "Copying to a different server is not yet implemented");
                return;
            }
            try {
                String tempDestPath = uri.getPath();
                if (tempDestPath.startsWith(request.getContextPath())) {
                    tempDestPath = tempDestPath.substring(request.getContextPath().length());
                }
                if (tempDestPath.startsWith(request.getServletPath())) {
                    tempDestPath = tempDestPath.substring(request.getServletPath().length());
                }
                destPath = XmldbURI.create(tempDestPath);
            }
            catch (URISyntaxException e) {
                response.sendError(400, "Malformed URL in destination header");
            }
            if (resource != null) {
                this.moveResource(user, broker, request, response, resource, destPath);
            } else {
                this.moveCollection(user, broker, request, response, collection, destPath);
            }
        }
        catch (EXistException e) {
            throw new ServletException("Failed to copy: " + e.getMessage(), (Throwable)e);
        }
        catch (LockException e) {
            throw new ServletException("Failed to copy: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (collection != null) {
                collection.release(1);
            }
            if (resource != null) {
                resource.getUpdateLock().release(1);
            }
            this.pool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveCollection(User user, DBBroker broker, HttpServletRequest request, HttpServletResponse response, Collection collection, XmldbURI destination) throws ServletException, IOException {
        if (collection.getURI().equals(destination)) {
            response.sendError(403, "Source and destination are the same");
            return;
        }
        if (destination.lastSegment() == null) {
            response.sendError(400, "Bad destination: " + destination);
            return;
        }
        Collection destCollection = null;
        TransactionManager transact = this.pool.getTransactionManager();
        try {
            Txn txn = transact.beginTransaction();
            try {
                boolean replaced = false;
                destCollection = broker.openCollection(destination, 1);
                if (destCollection != null) {
                    boolean overwrite = this.overwrite(request);
                    if (!overwrite) {
                        response.sendError(412, "Destination collection exists and overwrite is not allowed");
                        return;
                    }
                    broker.removeCollection(txn, destCollection);
                    replaced = true;
                }
                XmldbURI parentURI = destination.removeLastSegment();
                XmldbURI newCollURI = destination.lastSegment();
                LOG.debug((Object)("parent = " + parentURI + "; new name = " + newCollURI));
                destCollection = broker.openCollection(parentURI, 1);
                if (destCollection == null) {
                    response.sendError(409, "No parent collection: " + parentURI);
                    return;
                }
                broker.moveCollection(txn, collection, destCollection, newCollURI);
                if (replaced) {
                    response.setStatus(204);
                } else {
                    response.setStatus(201);
                }
            }
            catch (PermissionDeniedException e) {
                response.sendError(403, e.getMessage());
            }
            catch (LockException e) {
                response.sendError(500, e.getMessage());
            }
            finally {
                if (destCollection != null) {
                    destCollection.release(1);
                }
                transact.commit(txn);
                this.pool.release(broker);
            }
        }
        catch (TransactionException e) {
            response.sendError(500, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveResource(User user, DBBroker broker, HttpServletRequest request, HttpServletResponse response, DocumentImpl resource, XmldbURI destination) throws ServletException, IOException {
        XmldbURI docUri = destination.lastSegment();
        XmldbURI collUri = destination.removeLastSegment();
        if (docUri == null) {
            response.sendError(400, "Bad destination: " + destination);
            return;
        }
        boolean replaced = false;
        Collection destCollection = null;
        TransactionManager transact = broker.getBrokerPool().getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            destCollection = broker.openCollection(collUri, 1);
            if (destCollection == null) {
                transact.abort(transaction);
                response.sendError(409, "Destination collection not found");
                return;
            }
            DocumentImpl oldDoc = destCollection.getDocument(broker, docUri);
            if (oldDoc != null) {
                boolean overwrite = this.overwrite(request);
                if (!overwrite) {
                    transact.abort(transaction);
                    response.sendError(412, "Destination resource exists and overwrite is not allowed");
                    return;
                }
                replaced = true;
            }
            broker.moveXMLResource(transaction, resource, destCollection, docUri);
            resource.setUserLock(null);
            resource.getMetadata().setLockToken(null);
            transact.commit(transaction);
            if (replaced) {
                response.setStatus(204);
            } else {
                response.setStatus(201);
            }
        }
        catch (PermissionDeniedException e) {
            transact.abort(transaction);
            response.sendError(403, e.getMessage());
        }
        catch (LockException e) {
            transact.abort(transaction);
            response.sendError(500, e.getMessage());
        }
        catch (TransactionException e) {
            transact.abort(transaction);
            response.sendError(500, e.getMessage());
        }
        finally {
            if (destCollection != null) {
                destCollection.release(1);
            }
        }
    }

    private boolean overwrite(HttpServletRequest request) {
        String header = request.getHeader("Overwrite");
        if (header == null) {
            return false;
        }
        return header.equals("T");
    }
}

