/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.xacml;

import com.sun.xacml.PolicyTreeElement;
import com.sun.xacml.Rule;
import java.net.URI;
import org.exist.client.xacml.ConditionNode;
import org.exist.client.xacml.NodeContainer;
import org.exist.client.xacml.PolicyElementNode;
import org.exist.client.xacml.XACMLTreeNode;

public class RuleNode
extends PolicyElementNode {
    private int effect;
    private int originalEffect;
    private ConditionNode condition;

    public RuleNode(NodeContainer parent, Rule rule) {
        super(parent, (PolicyTreeElement)rule);
        if (rule == null) {
            this.effect = 1;
            this.condition = new ConditionNode(this);
        } else {
            this.effect = rule.getEffect();
            this.condition = new ConditionNode(this, rule.getCondition());
        }
        this.originalEffect = this.effect;
    }

    public int getEffect() {
        return this.effect;
    }

    public void setEffect(int effect) {
        if (effect != 1 && effect != 0) {
            throw new IllegalArgumentException("Invalid effect value: " + effect);
        }
        this.effect = effect;
        this.fireChanged();
    }

    public ConditionNode getCondition() {
        return this.condition;
    }

    public boolean isModified(boolean deep) {
        if (super.isModified(deep) || this.isEffectModified()) {
            return true;
        }
        return deep && this.condition.isModified(true);
    }

    public boolean isEffectModified() {
        return this.effect != this.originalEffect;
    }

    public void revert(boolean deep) {
        this.effect = this.originalEffect;
        if (deep) {
            this.condition.revert(deep);
        }
        super.revert(deep);
    }

    public void commit(boolean deep) {
        this.originalEffect = this.effect;
        if (deep) {
            this.condition.commit(deep);
        }
        super.commit(deep);
    }

    public PolicyTreeElement create() {
        return this.createRule();
    }

    public PolicyTreeElement create(URI id) {
        return this.createRule(id);
    }

    public Rule createRule() {
        return this.createRule(null);
    }

    public Rule createRule(URI id) {
        URI useId = id == null ? this.getId() : id;
        return new Rule(useId, this.effect, this.getDescription(), this.getTarget().getTarget(), this.condition.getCondition());
    }

    public int getChildCount() {
        return 2;
    }

    public XACMLTreeNode getChild(int index) {
        if (index == 0) {
            return this.getTarget();
        }
        if (index == 1) {
            return this.getCondition();
        }
        return null;
    }

    public int indexOfChild(Object child) {
        if (this.getTarget() == child) {
            return 0;
        }
        if (this.getCondition() == child) {
            return 1;
        }
        return -1;
    }
}

