/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.avalon.excalibur.cli.CLArgsParser;
import org.apache.avalon.excalibur.cli.CLOption;
import org.apache.avalon.excalibur.cli.CLOptionDescriptor;
import org.apache.avalon.excalibur.cli.CLUtil;
import org.exist.backup.Backup;
import org.exist.backup.CreateBackupDialog;
import org.exist.backup.Restore;
import org.exist.util.ConfigurationHelper;
import org.exist.xmldb.DatabaseInstanceManager;
import org.exist.xmldb.XmldbURI;
import org.xml.sax.SAXException;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;

public class Main {
    private static final int HELP_OPT = 104;
    private static final int USER_OPT = 117;
    private static final int PASS_OPT = 112;
    private static final int DBA_PASS_OPT = 80;
    private static final int BACKUP_OPT = 98;
    private static final int BACKUP_DIR_OPT = 100;
    private static final int RESTORE_OPT = 114;
    private static final int OPTION_OPT = 111;
    private static final int GUI_OPT = 85;
    private static final CLOptionDescriptor[] OPTIONS = new CLOptionDescriptor[]{new CLOptionDescriptor("help", 8, 104, "print help on command line options and exit."), new CLOptionDescriptor("gui", 8, 85, "start in GUI mode"), new CLOptionDescriptor("user", 2, 117, "set user."), new CLOptionDescriptor("password", 2, 112, "set the password for connecting to the database."), new CLOptionDescriptor("dba-password", 2, 80, "if the backup specifies a different password for the admin/dba user, use this option to specify the new password. Otherwise you will get a permission denied"), new CLOptionDescriptor("backup", 2, 98, "backup the specified collection."), new CLOptionDescriptor("dir", 2, 100, "specify the directory to use for backups."), new CLOptionDescriptor("restore", 2, 114, "read the specified restore file and restore the resources described there."), new CLOptionDescriptor("option", 48, 111, "specify extra options: property=value. For available properties see client.properties.")};

    public static void process(String[] args) {
        Properties properties = new Properties();
        try {
            File propFile = ConfigurationHelper.lookup("backup.properties");
            InputStream pin = propFile.canRead() ? new FileInputStream(propFile) : Main.class.getResourceAsStream("backup.properties");
            if (pin != null) {
                properties.load(pin);
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        CLArgsParser optParser = new CLArgsParser(args, OPTIONS);
        if (optParser.getErrorString() != null) {
            System.err.println("ERROR: " + optParser.getErrorString());
            return;
        }
        Vector opt = optParser.getArguments();
        int size = opt.size();
        String optionBackup = null;
        String optionRestore = null;
        String optionPass = null;
        String optionDbaPass = null;
        boolean doBackup = false;
        boolean doRestore = false;
        boolean guiMode = false;
        block32: for (int i = 0; i < size; ++i) {
            CLOption option = (CLOption)opt.get(i);
            switch (option.getId()) {
                case 104: {
                    Main.printUsage();
                    return;
                }
                case 85: {
                    guiMode = true;
                    continue block32;
                }
                case 111: {
                    properties.setProperty(option.getArgument(0), option.getArgument(1));
                    continue block32;
                }
                case 117: {
                    properties.setProperty("user", option.getArgument());
                    continue block32;
                }
                case 112: {
                    properties.setProperty("password", option.getArgument());
                    optionPass = option.getArgument();
                    continue block32;
                }
                case 80: {
                    optionDbaPass = option.getArgument();
                    continue block32;
                }
                case 98: {
                    optionBackup = option.getArgumentCount() == 1 ? option.getArgument() : null;
                    doBackup = true;
                    continue block32;
                }
                case 114: {
                    if (option.getArgumentCount() == 1) {
                        optionRestore = option.getArgument();
                    }
                    doRestore = true;
                    continue block32;
                }
                case 100: {
                    properties.setProperty("backup-dir", option.getArgument());
                }
            }
        }
        try {
            Class<?> cl = Class.forName(properties.getProperty("driver", "org.exist.xmldb.DatabaseImpl"));
            Database database = (Database)cl.newInstance();
            database.setProperty("create-database", "true");
            if (properties.containsKey("configuration")) {
                database.setProperty("configuration", properties.getProperty("configuration"));
            }
            DatabaseManager.registerDatabase((Database)database);
        }
        catch (ClassNotFoundException e) {
            Main.reportError(e);
            return;
        }
        catch (InstantiationException e) {
            Main.reportError(e);
            return;
        }
        catch (IllegalAccessException e) {
            Main.reportError(e);
            return;
        }
        catch (XMLDBException e) {
            Main.reportError(e);
            return;
        }
        if (doBackup) {
            if (optionBackup == null) {
                if (guiMode) {
                    CreateBackupDialog dialog = new CreateBackupDialog(properties.getProperty("uri", "xmldb:exist://"), properties.getProperty("user", "admin"), properties.getProperty("password", ""), properties.getProperty("backup-dir", System.getProperty("user.home") + File.separatorChar + "eXist-backup.zip"));
                    if (JOptionPane.showOptionDialog(null, dialog, "Create Backup", 2, 3, null, null, null) == 0) {
                        optionBackup = dialog.getCollection();
                        properties.setProperty("backup-dir", dialog.getBackupTarget());
                    }
                } else {
                    optionBackup = "/db";
                }
            }
            if (optionBackup != null) {
                try {
                    Backup backup = new Backup(properties.getProperty("user", "admin"), properties.getProperty("password", ""), properties.getProperty("backup-dir", "backup"), XmldbURI.xmldbUriFor(properties.getProperty("uri", "xmldb:exist://") + optionBackup), properties);
                    backup.backup(guiMode, null);
                }
                catch (XMLDBException e) {
                    Main.reportError(e);
                }
                catch (IOException e) {
                    Main.reportError(e);
                }
                catch (SAXException e) {
                    System.err.println("ERROR: " + e.getMessage());
                    System.err.println("caused by ");
                    e.getException().printStackTrace();
                }
                catch (URISyntaxException e) {
                    Main.reportError(e);
                }
            }
        }
        if (doRestore) {
            if (optionRestore == null && guiMode) {
                JFileChooser chooser = new JFileChooser();
                chooser.setMultiSelectionEnabled(false);
                chooser.setFileSelectionMode(0);
                if (chooser.showDialog(null, "Select backup file for restore") == 0) {
                    File f = chooser.getSelectedFile();
                    optionRestore = f.getAbsolutePath();
                }
            }
            if (optionRestore != null) {
                try {
                    Restore restore = new Restore(properties.getProperty("user", "admin"), optionPass, optionDbaPass, new File(optionRestore), properties.getProperty("uri", "xmldb:exist://"));
                    restore.restore(guiMode, null);
                }
                catch (FileNotFoundException e) {
                    Main.reportError(e);
                }
                catch (ParserConfigurationException e) {
                    Main.reportError(e);
                }
                catch (SAXException e) {
                    Main.reportError(e);
                }
                catch (XMLDBException e) {
                    Main.reportError(e);
                }
                catch (IOException e) {
                    Main.reportError(e);
                }
                catch (URISyntaxException e) {
                    Main.reportError(e);
                }
            }
        }
        try {
            Collection root = DatabaseManager.getCollection((String)(properties.getProperty("uri", "xmldb:exist://") + "/db"), (String)properties.getProperty("user", "admin"), (String)(optionDbaPass == null ? optionPass : optionDbaPass));
            Main.shutdown(root);
        }
        catch (XMLDBException e1) {
            e1.printStackTrace();
        }
        System.exit(0);
    }

    private static final void reportError(Throwable e) {
        System.err.println("ERROR: " + e.getMessage());
        e.printStackTrace();
        if (e.getCause() != null) {
            System.err.println("caused by ");
            e.getCause().printStackTrace();
        }
    }

    private static final void printUsage() {
        System.out.println("Usage: java " + Main.class.getName() + " [options]");
        System.out.println(CLUtil.describeOptions((CLOptionDescriptor[])OPTIONS).toString());
    }

    private static final void shutdown(Collection root) {
        try {
            DatabaseInstanceManager mgr = (DatabaseInstanceManager)root.getService("DatabaseInstanceManager", "1.0");
            if (mgr == null) {
                System.err.println("service is not available");
            } else if (mgr.isLocalInstance()) {
                System.out.println("shutting down database...");
                mgr.shutdown();
            }
        }
        catch (XMLDBException e) {
            System.err.println("database shutdown failed: ");
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Main.process(args);
    }
}

