<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
  xpath-default-namespace="http://www.tei-c.org/ns/1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:dhq="http://www.digitalhumanities.org/ns/dhq"
  xmlns="http://www.tei-c.org/ns/1.0" >

  <!-- Read in a DHQ article and write out a version-->
  <!-- thereof that is suitable for loading into XTF-->
  <!-- Written 2012-12-11 by Syd Bauman, copyleft -->

  <xsl:template match="@*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>
  
  <xsl:template match="front">
    <front>
      <titlePage>
        <titlePart type="teaser">
          <xsl:apply-templates select="//dhq:teaser/p"/>
        </titlePart>
        <titlePart>
          <title>
	  <xsl:apply-templates select="/TEI/teiHeader/fileDesc/titleStmt/title"/>
	  </title>
        </titlePart>
        <docAuthor>
	  <xsl:apply-templates select="/TEI/teiHeader/fileDesc/titleStmt/dhq:authorInfo/dhq:author_name"/>
	</docAuthor>
        <argument><xsl:apply-templates select="//dhq:abstract"/></argument>
      </titlePage>
    </front>
  </xsl:template>
  
  <xsl:template match="div">
    <xsl:variable name="num">
      <xsl:number level="multiple"/>
    </xsl:variable>
    <xsl:variable name="ID" select="concat(
      'art-',
      /TEI/teiHeader/fileDesc/publicationStmt/idno[@type='DHQarticle-id'],
      '.div-',
      $num
      )"/>
    <div>
      <xsl:apply-templates select="@*"/>
      <xsl:if test="not(@xml:id)">
        <xsl:attribute name="xml:id" select="$ID"/>
      </xsl:if>
      <xsl:apply-templates select="node()"/>
    </div>
  </xsl:template>
  
</xsl:stylesheet>
