/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.marc4j.marcxml.Converter;
import org.marc4j.marcxml.MarcResult;
import org.marc4j.marcxml.SaxErrorHandler;
import org.marc4j.util.CharacterConverter;
import org.marc4j.util.MarcWriter;
import org.marc4j.util.UnicodeToAnsel;
import org.marc4j.util.UnicodeToIso5426;
import org.marc4j.util.UnicodeToIso6937;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class XmlMarcWriter {
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        long l = System.currentTimeMillis();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-dtd")) {
                bl2 = true;
            } else if (stringArray[n].equals("-xsd")) {
                bl3 = true;
            } else if (stringArray[n].equals("-xsdss")) {
                if (n == stringArray.length - 1) {
                    XmlMarcWriter.usage();
                }
                bl3 = true;
                string4 = stringArray[++n];
            } else if (stringArray[n].equals("-out")) {
                if (n == stringArray.length - 1) {
                    XmlMarcWriter.usage();
                }
                string2 = stringArray[++n];
            } else if (stringArray[n].equals("-convert")) {
                if (n == stringArray.length - 1) {
                    XmlMarcWriter.usage();
                }
                string5 = stringArray[++n].trim();
            } else if (stringArray[n].equals("-xsl")) {
                if (n == stringArray.length - 1) {
                    XmlMarcWriter.usage();
                }
                string3 = stringArray[++n];
            } else if (stringArray[n].equals("-usage")) {
                XmlMarcWriter.usage();
            } else if (stringArray[n].equals("-help")) {
                XmlMarcWriter.usage();
            } else {
                string = stringArray[n];
                if (n != stringArray.length - 1) {
                    XmlMarcWriter.usage();
                }
            }
            ++n;
        }
        if (string == null) {
            XmlMarcWriter.usage();
        }
        try {
            Object object;
            BufferedWriter bufferedWriter = string2 == null ? (string5 != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "ISO8859_1")) : new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF8"))) : (string5 != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2), "ISO8859_1")) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2), "UTF8")));
            MarcWriter marcWriter = new MarcWriter(bufferedWriter);
            if (string5 != null) {
                object = null;
                if ("ANSEL".equals(string5)) {
                    object = new UnicodeToAnsel();
                } else if ("ISO5426".equals(string5)) {
                    object = new UnicodeToIso5426();
                } else if ("ISO6937".equals(string5)) {
                    object = new UnicodeToIso6937();
                } else {
                    System.err.println("Unknown character set");
                    System.exit(1);
                }
                marcWriter.setCharacterConverter((CharacterConverter)object);
            }
            object = SAXParserFactory.newInstance();
            ((SAXParserFactory)object).setNamespaceAware(true);
            ((SAXParserFactory)object).setValidating(bl2 || bl3);
            SAXParser sAXParser = ((SAXParserFactory)object).newSAXParser();
            if (bl3) {
                sAXParser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            }
            if (string4 != null) {
                sAXParser.setProperty(JAXP_SCHEMA_SOURCE, new File(string4));
            }
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setErrorHandler(new SaxErrorHandler());
            InputSource inputSource = new InputSource(new File(string).toURL().toString());
            SAXSource sAXSource = new SAXSource(xMLReader, inputSource);
            MarcResult marcResult = new MarcResult(marcWriter);
            Converter converter = new Converter();
            if (string3 != null) {
                StreamSource streamSource = new StreamSource(new File(string3).toURL().toString());
                converter.convert((Source)streamSource, (Source)sAXSource, (Result)marcResult);
            } else {
                converter.convert(sAXSource, (Result)marcResult);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            sAXNotSupportedException.printStackTrace();
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            sAXNotRecognizedException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.err.println("Total time: " + (System.currentTimeMillis() - l) + " miliseconds");
    }

    private static void usage() {
        System.err.println("MARC4J version beta 7, Copyright (C) 2002-2003 Bas Peters");
        System.err.println("Usage: org.marc4j.util.XmlMarcWriter [-options] <file.xml>");
        System.err.println("Usage: MarcXmlWriter [-options] <file.xml>");
        System.err.println("       -dtd = DTD validation");
        System.err.println("       -xsd = W3C XML Schema validation: hints in instance document");
        System.err.println("       -xsdss <file> = W3C XML Schema validation using schema source <file>");
        System.err.println("       -xsl <file> = Preprocess XML using XSLT stylesheet <file>");
        System.err.println("       -out <file> = Output using <file>");
        System.err.println("       -convert [ANSEL | ISO5426 | ISO6937] = convert from UTF-8");
        System.err.println("          to specified character set");
        System.err.println("       -usage or -help = this message");
        System.err.println("See http://marc4j.tigris.org for more information.");
        System.exit(1);
    }
}

