/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.dbxml;

import com.sleepycat.dbxml.XmlException;
import com.sleepycat.dbxml.XmlValue;

public class XmlMetaData {
    private String name;
    private XmlValue value;
    private String uri;
    private boolean modified;
    private boolean removed;

    protected XmlMetaData(String uri, String name, XmlValue value) throws XmlException {
        if (value.isNull() || value.isNode()) {
            throw new XmlException(14, "Metadata cannot be a node or null value.");
        }
        this.name = name;
        this.value = value;
        this.uri = uri;
        this.modified = false;
        this.removed = false;
    }

    public String get_uri() throws XmlException {
        return this.uri;
    }

    public String get_name() throws XmlException {
        return this.name;
    }

    public XmlValue get_value() throws XmlException {
        return this.value;
    }

    protected void set_modified(boolean mod) {
        this.modified = mod;
    }

    protected void set_removed(boolean rem) {
        this.removed = rem;
    }

    protected boolean get_modified() {
        return this.modified;
    }

    protected boolean get_removed() {
        return this.removed;
    }

    protected void set_value(XmlValue data) throws XmlException {
        if (this.value.isNull() || this.value.isNode()) {
            throw new XmlException(14, "Metadata cannot be a node or null value.");
        }
        this.value = data;
    }
}

