/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.xslt;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.XPathException;
import org.cdlib.xtf.textIndexer.HTMLToString;
import org.cdlib.xtf.util.Path;
import org.cdlib.xtf.xslt.XMLStubReader;
import org.xml.sax.InputSource;

public class FileUtils {
    private static HashMap dateFormatCache = new HashMap();
    private static ThreadLocal<ArrayList<File>> tempFiles = new ThreadLocal();
    private static final long MILLISECS_PER_MINUTE = 60000L;
    private static final long MILLISECS_PER_HOUR = 3600000L;
    private static final long MILLISECS_PER_DAY = 86400000L;

    public static boolean exists(XPathContext context, String filePath) {
        File file = FileUtils.resolveFile(context, filePath);
        return file.canRead();
    }

    public static String lastModified(XPathContext context, String filePath, String formatStr) {
        File file = FileUtils.resolveFile(context, filePath);
        if (!file.canRead()) {
            return null;
        }
        SimpleDateFormat fmt = FileUtils.getDateFormat(formatStr);
        String result = fmt.format(new Date(file.lastModified()));
        return result;
    }

    public static long length(XPathContext context, String filePath) {
        File file = FileUtils.resolveFile(context, filePath);
        if (!file.canRead()) {
            return -1L;
        }
        return file.length();
    }

    public static String humanFileSize(Long longFileSize) {
        if (longFileSize < 0L) {
            return "";
        }
        if (longFileSize < 512L) {
            return longFileSize.toString();
        }
        DecimalFormat outputFormat = new DecimalFormat("0.00");
        StringBuffer outputStrBuf = new StringBuffer();
        FieldPosition fieldPos = new FieldPosition(0);
        if (longFileSize < 524288L) {
            double doubleBytes = longFileSize.doubleValue() / 1024.0;
            outputFormat.format(doubleBytes, outputStrBuf, fieldPos);
            return String.valueOf(outputStrBuf.toString()) + " Kb";
        }
        if (longFileSize < 0x20000000L) {
            double doubleBytes = longFileSize.doubleValue() / 1048576.0;
            outputFormat.format(doubleBytes, outputStrBuf, fieldPos);
            return String.valueOf(outputStrBuf.toString()) + " Mb";
        }
        if (longFileSize < 0x8000000000L) {
            double doubleBytes = longFileSize.doubleValue() / 1.073741824E9;
            outputFormat.format(doubleBytes, outputStrBuf, fieldPos);
            return String.valueOf(outputStrBuf.toString()) + " Gb";
        }
        if (longFileSize < 0x2000000000000L) {
            double doubleBytes = longFileSize.doubleValue() / 1.099511627776E12;
            outputFormat.format(doubleBytes, outputStrBuf, fieldPos);
            return String.valueOf(outputStrBuf.toString()) + " Tb";
        }
        if (longFileSize < 0x800000000000000L) {
            double doubleBytes = longFileSize.doubleValue() / 1.125899906842624E15;
            outputFormat.format(doubleBytes, outputStrBuf, fieldPos);
            return String.valueOf(outputStrBuf.toString()) + " Pb";
        }
        double doubleBytes = longFileSize.doubleValue() / 1.152921504606847E18;
        outputFormat.format(doubleBytes, outputStrBuf, fieldPos);
        return String.valueOf(outputStrBuf.toString()) + " Eb";
    }

    public static String md5Hash(String inputString) {
        BigInteger bigInt;
        MessageDigest msgDigest;
        try {
            msgDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            return "";
        }
        msgDigest.update(inputString.getBytes(), 0, inputString.length());
        try {
            bigInt = new BigInteger(1, msgDigest.digest());
        }
        catch (Exception e) {
            return "";
        }
        String outputString = bigInt.toString(16);
        if (outputString.length() % 2 == 1) {
            outputString = "0" + outputString;
        }
        return outputString;
    }

    /*
     * Unable to fully structure code
     */
    private static String getSystemId(XPathContext context) {
        try {
            return context.getOrigin().getInstructionInfo().getSystemId();
        }
        catch (NoSuchMethodError e) {
            var5_2 = context.getClass().getMethods();
            var4_3 = var5_2.length;
            var3_4 = 0;
            ** while (var3_4 < var4_3)
        }
lbl-1000:
        // 1 sources

        {
            method = var5_2[var3_4];
            if (method.getName().equals("getOrigin")) {
                try {
                    return ((InstructionInfo)method.invoke((Object)context, new Object[0])).getSystemId();
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
            ++var3_4;
            continue;
        }
lbl16:
        // 1 sources

        return null;
    }

    public static File resolveFile(XPathContext context, String filePath) {
        String stylesheetPath = FileUtils.getSystemId(context);
        stylesheetPath = stylesheetPath.replaceFirst("^file:", "");
        stylesheetPath = stylesheetPath.replaceAll("%20", " ");
        File stylesheetDir = new File(stylesheetPath).getParentFile();
        filePath = filePath.replaceFirst("^file:", "");
        filePath = filePath.replaceAll("%20", " ");
        String resolved = Path.resolveRelOrAbs(stylesheetDir, filePath);
        return new File(resolved);
    }

    public static String resolvePath(XPathContext context, String filePath) {
        String stylesheetPath = FileUtils.getSystemId(context);
        stylesheetPath = stylesheetPath.replaceFirst("^file:", "");
        stylesheetPath = stylesheetPath.replaceAll("%20", " ");
        File stylesheetDir = new File(stylesheetPath).getParentFile();
        filePath = filePath.replaceFirst("^file:", "");
        filePath = filePath.replaceAll("%20", " ");
        String resolved = Path.resolveRelOrAbs(stylesheetDir, filePath);
        return Path.normalize(resolved);
    }

    public static String curDateTime(XPathContext context, String formatStr) {
        SimpleDateFormat fmt = FileUtils.getDateFormat(formatStr);
        String result = fmt.format(new Date());
        return result;
    }

    public static long timeSince(XPathContext context, String targetDateStr, String units, String formatStr) {
        try {
            SimpleDateFormat fmt = FileUtils.getDateFormat(formatStr);
            Date targetDate = fmt.parse(targetDateStr);
            Calendar tmpCal = Calendar.getInstance();
            tmpCal.setTime(targetDate);
            long targetMillis = FileUtils.adjustedMillis(tmpCal);
            tmpCal.setTime(new Date());
            long currentMillis = FileUtils.adjustedMillis(tmpCal);
            long diff = currentMillis - targetMillis;
            if (units.matches("d|D|day|Day|days|Days")) {
                return diff / 86400000L;
            }
            if (units.matches("h|H|hour|Hour|hours|Hours")) {
                return diff / 3600000L;
            }
            if (units.matches("m|M|min|Min|minute|Minute|minutes|Minutes")) {
                return diff / 60000L;
            }
            throw new RuntimeException("timeSince units must be days, hours, or minutes (or d/h/m)");
        }
        catch (ParseException e) {
            throw new RuntimeException("error parsing date '" + targetDateStr + "'");
        }
    }

    private static long adjustedMillis(Calendar cal) {
        return cal.getTimeInMillis() + (long)cal.getTimeZone().getOffset(cal.getTimeInMillis());
    }

    private static SimpleDateFormat getDateFormat(String formatStr) {
        if (!dateFormatCache.containsKey(formatStr)) {
            dateFormatCache.put(formatStr, new SimpleDateFormat(formatStr));
        }
        return (SimpleDateFormat)dateFormatCache.get(formatStr);
    }

    public static String createTempFile(XPathContext context, String prefix, String suffix) throws IOException {
        File out = File.createTempFile(prefix, suffix);
        out.delete();
        ArrayList<File> files = tempFiles.get();
        if (files == null) {
            files = new ArrayList();
            tempFiles.set(files);
        }
        tempFiles.get().add(out);
        return out.getAbsolutePath();
    }

    public static void deleteTempFiles() {
        ArrayList<File> files = tempFiles.get();
        if (files != null) {
            for (File f : files) {
                f.delete();
            }
            files.clear();
            tempFiles.set(null);
        }
    }

    public static DocumentInfo readXMLStub(XPathContext context, String filePath) throws IOException, XPathException {
        File file = FileUtils.resolveFile(context, filePath);
        if (!file.canRead()) {
            throw new IOException("Cannot read file '" + file.toString() + "'");
        }
        XMLStubReader xmlReader = new XMLStubReader();
        BufferedInputStream bufStream = new BufferedInputStream(new FileInputStream(file));
        try {
            DocumentInfo doc;
            InputSource inputSrc = new InputSource(bufStream);
            inputSrc.setSystemId(file.toURI().toString());
            SAXSource saxSrc = new SAXSource(xmlReader, inputSrc);
            DocumentInfo documentInfo = doc = context.getConfiguration().buildDocument(saxSrc);
            return documentInfo;
        }
        finally {
            bufStream.close();
        }
    }

    public static DocumentInfo readHTMLPage(XPathContext context, String urlStr) throws IOException, XPathException {
        String pageStr;
        InputStream inStream = null;
        try {
            URL url = new URL(urlStr);
            URLConnection connection = url.openConnection();
            inStream = connection.getInputStream();
            pageStr = HTMLToString.convert(inStream);
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
        }
        DocumentInfo doc = context.getConfiguration().buildDocument(new StreamSource(new StringReader(pageStr), urlStr));
        return doc;
    }
}

