/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import org.apache.lucene.util.Prime;
import org.cdlib.xtf.util.Tester;

public class IntHash {
    private final int hashSize;
    private final Ent[] ents;
    private int curSize;
    public static final Tester tester = new Tester("IntHash"){

        protected void testImpl() {
            IntHash hash = new IntHash(5);
            hash.put(100, "hello");
            if (!$assertionsDisabled && !hash.contains(100)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && hash.contains(111)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !hash.get(100).equals("hello")) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && hash.size() != 1) {
                throw new AssertionError();
            }
            hash.put(200, "foo");
            hash.put(211, "bar");
            if (!$assertionsDisabled && !hash.contains(100)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !hash.contains(200)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !hash.contains(211)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && hash.contains(111)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && hash.contains(212)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && hash.size() != 3) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !hash.get(100).equals("hello")) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !hash.get(200).equals("foo")) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !hash.get(211).equals("bar")) {
                throw new AssertionError();
            }
        }
    };

    public IntHash(int maxSize) {
        this.hashSize = Prime.findAfter(maxSize * 2);
        this.ents = new Ent[this.hashSize];
        this.curSize = 0;
    }

    public void put(int key, Object val) {
        int bucket = key % this.hashSize;
        Ent e = this.ents[bucket];
        while (e != null) {
            if (key == e.key) {
                e.val = val;
                return;
            }
            e = e.next;
        }
        e = new Ent();
        e.key = key;
        e.val = val;
        e.next = this.ents[bucket];
        this.ents[bucket] = e;
        ++this.curSize;
    }

    public boolean contains(int key) {
        Ent e = this.ents[key % this.hashSize];
        while (e != null) {
            if (key == e.key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Object get(int key) {
        Ent e = this.ents[key % this.hashSize];
        while (e != null) {
            if (key == e.key) {
                return e.val;
            }
            e = e.next;
        }
        return null;
    }

    public int size() {
        return this.curSize;
    }

    private class Ent {
        int key;
        Object val;
        Ent next;

        private Ent() {
        }
    }
}

