/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import org.cdlib.xtf.util.FastHashMap;
import org.cdlib.xtf.util.Tester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastCache<K, V> {
    private int size;
    private FastHashMap<K, V> oldHash;
    private FastHashMap<K, V> newHash;
    public static final Tester tester = new Tester("FastCache"){

        protected void testImpl() {
            FastHashMap.tester.test();
            FastCache<String, String> cache = new FastCache<String, String>(3);
            cache.put("1", "a");
            cache.put("2", "b");
            cache.put("3", "c");
            if (!$assertionsDisabled && !cache.contains("1")) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !cache.contains("2")) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !cache.contains("3")) {
                throw new AssertionError();
            }
            cache.put("4", "d");
            if (!$assertionsDisabled && !cache.get("2").equals("b")) {
                throw new AssertionError();
            }
            cache.put("5", "e");
            cache.put("6", "f");
            if (!$assertionsDisabled && cache.contains("1")) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !cache.contains("2")) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !cache.contains("5")) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !cache.contains("6")) {
                throw new AssertionError();
            }
        }
    };

    public FastCache(int size) {
        this.size = size;
        this.clear();
    }

    public void clear() {
        this.oldHash = new FastHashMap(1);
        this.newHash = new FastHashMap(this.size);
    }

    public boolean contains(K key) {
        return this.newHash.contains(key) || this.oldHash.contains(key);
    }

    public V get(K key) {
        V retVal = this.newHash.get(key);
        if (retVal == null && (retVal = this.oldHash.get(key)) != null) {
            this.put(key, retVal);
        }
        return retVal;
    }

    public void put(K key, V val) {
        if (this.newHash.size() >= this.size) {
            this.oldHash = this.newHash;
            this.newHash = new FastHashMap(this.size);
        }
        this.newHash.put(key, val);
    }
}

