/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyNode {
    private NodeInfo wrapped;
    private ArrayList<String> attrNames;
    private ArrayList<String> attrValues;
    private ArrayList<EasyNode> children;
    private static Configuration config = new Configuration();

    public static EasyNode readXMLFile(String path) {
        return EasyNode.readXMLFile(new File(path));
    }

    public static EasyNode readXMLFile(File path) {
        StreamSource src = new StreamSource(path);
        NodeInfo doc = null;
        try {
            doc = TinyBuilder.build((Source)src, (Stripper)new AllElementStripper(), config);
            return new EasyNode(doc);
        }
        catch (XPathException e) {
            throw new RuntimeException(e);
        }
    }

    public EasyNode(NodeInfo toWrap) {
        this.wrapped = toWrap;
    }

    private void getAttrs() {
        NodeInfo attr;
        if (this.attrNames != null) {
            return;
        }
        this.attrNames = new ArrayList();
        this.attrValues = new ArrayList();
        AxisIterator iter = this.wrapped.iterateAxis((byte)2);
        while ((attr = (NodeInfo)iter.next()) != null) {
            String name = attr.getLocalPart();
            String val = attr.getStringValue();
            this.attrNames.add(name);
            this.attrValues.add(val);
        }
    }

    private void getChildren() {
        NodeInfo child;
        if (this.children != null) {
            return;
        }
        this.children = new ArrayList();
        AxisIterator iter = this.wrapped.iterateAxis((byte)3);
        while ((child = (NodeInfo)iter.next()) != null) {
            if (child.getNodeKind() != 1 && child.getNodeKind() != 3) continue;
            this.children.add(new EasyNode(child));
        }
    }

    public int nAttrs() {
        this.getAttrs();
        return this.attrNames.size();
    }

    public String attrName(int index) {
        this.getAttrs();
        return this.attrNames.get(index);
    }

    public List<String> attrNames() {
        this.getAttrs();
        return this.attrNames;
    }

    public String attrValue(int index) {
        this.getAttrs();
        return this.attrValues.get(index);
    }

    public boolean hasAttr(String name) {
        return this.attrValue(name) != null;
    }

    public String attrValue(String name) {
        this.getAttrs();
        int i = 0;
        while (i < this.attrNames.size()) {
            if (this.attrNames.get(i).equalsIgnoreCase(name)) {
                return this.attrValues.get(i);
            }
            ++i;
        }
        return null;
    }

    public int nChildren() {
        this.getChildren();
        return this.children.size();
    }

    public EasyNode child(int index) {
        this.getChildren();
        return this.children.get(index);
    }

    public EasyNode child(String name) {
        this.getChildren();
        int i = 0;
        while (i < this.children.size()) {
            if (this.children.get(i).name().equalsIgnoreCase(name)) {
                return this.children.get(i);
            }
            ++i;
        }
        return null;
    }

    public List<EasyNode> children() {
        this.getChildren();
        return this.children;
    }

    public EasyNode parent() {
        NodeInfo parent = this.wrapped.getParent();
        if (parent == null) {
            return null;
        }
        return new EasyNode(parent);
    }

    public String name() {
        return this.wrapped.getLocalPart();
    }

    public boolean isElement() {
        return this.wrapped.getNodeKind() == 1;
    }

    public boolean isText() {
        return this.wrapped.getNodeKind() == 3;
    }

    public String toString() {
        return this.wrapped.getStringValue();
    }

    public NodeInfo getWrappedNode() {
        return this.wrapped;
    }
}

