/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine.facet;

import java.util.Vector;
import org.cdlib.xtf.textEngine.facet.GroupSelector;

public class TopChoiceSelector
extends GroupSelector {
    private int bestLevel;
    private int bestParent;
    private Vector bestChildren = new Vector(10);
    private int[] firstChild;

    public void reset(boolean conservative) {
        super.reset(conservative);
        this.bestLevel = 999999999;
        this.bestParent = -1;
        this.firstChild = new int[this.counts.nGroups()];
    }

    public void process(int group) {
        if (this.conservative) {
            this.next.process(group);
            return;
        }
        int parent = this.counts.parent(group);
        if (this.firstChild[parent] == 0) {
            this.firstChild[parent] = group;
            return;
        }
        if (parent == this.bestParent) {
            this.bestChildren.add(group);
            return;
        }
        int level = 0;
        int g = parent;
        while (g >= 0) {
            ++level;
            g = this.counts.parent(g);
        }
        if (level >= this.bestLevel) {
            return;
        }
        this.bestParent = parent;
        this.bestLevel = level;
        this.bestChildren.setSize(0);
        this.bestChildren.add(this.firstChild[parent]);
        this.bestChildren.add(group);
    }

    public void flush() {
        if (this.bestParent >= 0) {
            int i = 0;
            while (i < this.bestChildren.size()) {
                this.next.process((Integer)this.bestChildren.elementAt(i));
                ++i;
            }
        }
        this.next.flush();
    }

    public String toString() {
        return "topChoices -> " + this.next.toString();
    }
}

