/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.SpanWildcardQuery;
import org.cdlib.xtf.textEngine.XtfQueryRewriter;
import org.cdlib.xtf.textEngine.XtfSpanWildcardQuery;
import org.cdlib.xtf.util.FastCache;
import org.cdlib.xtf.util.Normalizer;

public class UnicodeNormalizingRewriter
extends XtfQueryRewriter {
    private static final int CACHE_SIZE = 5000;
    private FastCache<String, String> cache = new FastCache(5000);
    private Set tokenizedFields;

    public UnicodeNormalizingRewriter(Set tokFields) {
        this.tokenizedFields = tokFields;
    }

    protected Query rewrite(TermQuery q) {
        return q;
    }

    protected Query rewrite(SpanTermQuery q) {
        String newText;
        Term t = q.getTerm();
        if (!this.tokenizedFields.contains(t.field())) {
            return q;
        }
        String text = t.text();
        if (!this.cache.contains(text)) {
            String normalizedText = Normalizer.normalize(text);
            this.cache.put(text, normalizedText);
        }
        if ((newText = this.cache.get(text)).equals(text)) {
            return q;
        }
        Term newTerm = new Term(t.field(), newText);
        return this.copyBoost(q, new SpanTermQuery(newTerm, q.getTermLength()));
    }

    protected Query rewrite(SpanWildcardQuery q) {
        String newText;
        assert (q instanceof XtfSpanWildcardQuery);
        Term t = q.getTerm();
        if (!this.tokenizedFields.contains(t.field())) {
            return q;
        }
        String text = t.text();
        if (!this.cache.contains(text)) {
            String normalizedText = Normalizer.normalize(text);
            this.cache.put(text, normalizedText);
        }
        if ((newText = this.cache.get(text)).equals(text)) {
            return q;
        }
        Term newTerm = new Term(t.field(), newText);
        return this.copyBoost(q, new XtfSpanWildcardQuery(newTerm, q.getTermLimit()));
    }
}

