/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.util.Set;
import org.apache.lucene.chunk.DocNumMap;
import org.apache.lucene.chunk.SpanChunkedNotQuery;
import org.apache.lucene.chunk.SpanDechunkingQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanOrNearQuery;
import org.apache.lucene.search.spans.SpanRangeQuery;
import org.apache.lucene.search.spans.SpanWildcardQuery;
import org.cdlib.xtf.textEngine.MoreLikeThisQuery;
import org.cdlib.xtf.textEngine.XtfQueryRewriter;
import org.cdlib.xtf.textEngine.XtfSpanRangeQuery;
import org.cdlib.xtf.textEngine.XtfSpanWildcardQuery;
import org.cdlib.xtf.util.CharMap;
import org.cdlib.xtf.util.WordMap;

public class SlopFixupRewriter
extends XtfQueryRewriter {
    private DocNumMap docNumMap;
    private Set stopSet;
    private WordMap pluralMap;
    private CharMap accentMap;

    public SlopFixupRewriter(DocNumMap docNumMap, Set stopSet, WordMap pluralMap, CharMap accentMap) {
        this.docNumMap = docNumMap;
        this.stopSet = stopSet;
        this.pluralMap = pluralMap;
        this.accentMap = accentMap;
    }

    public boolean forceRewrite(Query q) {
        return q instanceof SpanNearQuery || q instanceof SpanOrNearQuery || q instanceof SpanChunkedNotQuery || q instanceof SpanDechunkingQuery || q instanceof SpanWildcardQuery || q instanceof SpanRangeQuery || q instanceof MoreLikeThisQuery;
    }

    public Query rewrite(SpanNearQuery nq) {
        boolean isText = nq.getField().equals("text");
        int maxSlop = isText ? this.docNumMap.getChunkOverlap() : 999999;
        int targetSlop = Math.min(nq.getSlop(), maxSlop);
        if (targetSlop == nq.getSlop()) {
            return super.rewrite(nq);
        }
        SpanNearQuery newQ = (SpanNearQuery)super.rewrite(nq);
        assert (newQ != nq);
        newQ.setSlop(targetSlop);
        return newQ;
    }

    public Query rewrite(SpanOrNearQuery nq) {
        boolean isText = nq.getField().equals("text");
        int maxSlop = isText ? this.docNumMap.getChunkOverlap() : 999999;
        int targetSlop = Math.min(nq.getSlop(), maxSlop);
        if (targetSlop == nq.getSlop()) {
            return super.rewrite(nq);
        }
        SpanOrNearQuery newQ = (SpanOrNearQuery)super.rewrite(nq);
        assert (newQ != nq);
        newQ.setSlop(targetSlop);
        return newQ;
    }

    public Query rewrite(SpanChunkedNotQuery nq) {
        SpanChunkedNotQuery newq = (SpanChunkedNotQuery)super.rewrite(nq);
        assert (newq != nq);
        newq.setSlop(Math.min(nq.getSlop(), this.docNumMap.getChunkOverlap()), this.docNumMap.getChunkSize() - this.docNumMap.getChunkOverlap());
        return newq;
    }

    public Query rewrite(SpanDechunkingQuery q) {
        SpanDechunkingQuery newq = (SpanDechunkingQuery)super.rewrite(q);
        assert (newq != q);
        newq.setDocNumMap(this.docNumMap);
        return newq;
    }

    public Query rewrite(SpanWildcardQuery q) {
        assert (q instanceof XtfSpanWildcardQuery);
        XtfSpanWildcardQuery newq = (XtfSpanWildcardQuery)super.rewrite(q);
        assert (newq != q);
        newq.setStopWords(this.stopSet);
        return newq;
    }

    public Query rewrite(SpanRangeQuery q) {
        assert (q instanceof XtfSpanRangeQuery);
        XtfSpanRangeQuery newq = (XtfSpanRangeQuery)super.rewrite(q);
        assert (newq != q);
        newq.setStopWords(this.stopSet);
        return newq;
    }

    public Query rewrite(MoreLikeThisQuery q) {
        MoreLikeThisQuery newq = (MoreLikeThisQuery)super.rewrite(q);
        assert (newq != q);
        newq.setStopWords(this.stopSet);
        newq.setPluralMap(this.pluralMap);
        newq.setAccentMap(this.accentMap);
        return newq;
    }
}

