/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.lucene.store.Directory;
import org.cdlib.xtf.textEngine.FlippingDirectory;
import org.cdlib.xtf.textEngine.IndexValidator;
import org.cdlib.xtf.textEngine.NativeFSDirectory;
import org.cdlib.xtf.textEngine.XtfSearcher;
import org.cdlib.xtf.util.Path;
import org.cdlib.xtf.util.Trace;

public class IndexWarmer {
    private String xtfHome;
    private HashMap<String, Entry> entries = new HashMap();
    private BgThread bgThread;
    private int updateInterval;

    public IndexWarmer(String xtfHome, int updateInterval) {
        this.xtfHome = xtfHome;
        this.updateInterval = updateInterval;
        if (updateInterval > 0) {
            this.bgThread = new BgThread(this);
            this.bgThread.setDaemon(true);
            this.bgThread.start();
        }
    }

    public void close() {
        if (this.bgThread != null) {
            this.bgThread.shouldStop = true;
            this.bgThread.interrupt();
        }
        for (Entry e : this.entries.values()) {
            if (e.curSearcher != null) {
                try {
                    e.curSearcher.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (e.newSearcher == null) continue;
            try {
                e.curSearcher.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized XtfSearcher getSearcher(String indexPath) throws IOException {
        indexPath = Path.resolveRelOrAbs(this.xtfHome, indexPath);
        Entry ent = this.entries.get(indexPath);
        if (Thread.currentThread() == this.bgThread) {
            String nonPendingPath = indexPath.replaceAll("-pending$", "");
            ent = this.entries.get(nonPendingPath);
            assert (ent != null);
            return ent.newSearcher;
        }
        if (ent == null) {
            ent = new Entry(Path.resolveRelOrAbs(this.xtfHome, indexPath));
            this.entries.put(indexPath, ent);
        }
        if (ent.curSearcher == null) {
            if (this.bgThread != null && !indexPath.endsWith("-new")) {
                IndexWarmer indexWarmer = this.bgThread.warmer;
                synchronized (indexWarmer) {
                    this.bgThread.warm(ent, false);
                }
            } else {
                ent.curSearcher = new XtfSearcher(indexPath, 0);
            }
            if (ent.curSearcher == null) {
                throw new RuntimeException("Error opening XTF search index. Perhaps you need to run the textIndexer?");
            }
        }
        return ent.curSearcher;
    }

    private static class BgThread
    extends Thread {
        private IndexWarmer warmer;
        private long prevWarmTime = 0L;
        private boolean shouldStop = false;

        BgThread(IndexWarmer warmer) {
            this.warmer = warmer;
        }

        public void run() {
            while (!this.shouldStop) {
                long curTime;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    return;
                }
                Entry toUpdate = this.scanForUpdates();
                if (toUpdate == null || (curTime = System.currentTimeMillis()) - this.prevWarmTime < (long)(this.warmer.updateInterval * 1000)) continue;
                this.warm(toUpdate, true);
                this.prevWarmTime = curTime;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Entry scanForUpdates() {
            IndexWarmer indexWarmer = this.warmer;
            synchronized (indexWarmer) {
                for (Entry ent : this.warmer.entries.values()) {
                    if (ent.exception != null) {
                        if (System.currentTimeMillis() - ent.exceptionTime < 60000L) continue;
                        ent.exception = null;
                    }
                    if (ent.newPath.exists() && (ent.pendingPath.exists() || ent.sparePath.exists())) {
                        if (!ent.pendingPath.exists()) continue;
                        return ent;
                    }
                    if (ent.curSearcher == null) continue;
                    try {
                        if (ent.curSearcher.isUpToDate()) continue;
                        return ent;
                    }
                    catch (IOException e) {
                        ent.exception = e;
                        ent.exceptionTime = System.currentTimeMillis();
                        Trace.error(String.format("Error checking index '%s': %s", ent.indexPath, e.toString()));
                    }
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void warm(Entry ent, boolean validateOk) {
            try {
                IndexValidator val;
                Directory dir;
                File indexPath;
                Trace.info(String.format("Warming index [%s]", ent.indexPath));
                Trace.tab();
                if (ent.newPath.exists() && ent.pendingPath.exists()) {
                    indexPath = ent.pendingPath;
                    dir = new FlippingDirectory(NativeFSDirectory.getDirectory(indexPath));
                } else {
                    indexPath = ent.currentPath;
                    dir = NativeFSDirectory.getDirectory(indexPath);
                }
                ent.newSearcher = new XtfSearcher(indexPath.toString(), dir, 0);
                if (validateOk && !(val = new IndexValidator()).validate(this.warmer.xtfHome, indexPath.toString(), ent.newSearcher.indexReader())) {
                    Trace.warning("Index validation failed; using index anyway.");
                }
                IndexWarmer indexWarmer = this.warmer;
                synchronized (indexWarmer) {
                    if (dir instanceof FlippingDirectory) {
                        if (ent.currentPath.exists() && !ent.currentPath.renameTo(ent.sparePath)) {
                            throw new IOException(String.format("Error renaming '%s' to '%s'", ent.currentPath, ent.sparePath));
                        }
                        if (!ent.pendingPath.renameTo(ent.currentPath)) {
                            throw new IOException(String.format("Error renaming '%s' to '%s'", ent.pendingPath, ent.currentPath));
                        }
                        ((FlippingDirectory)dir).flipTo(NativeFSDirectory.getDirectory(ent.currentPath));
                    }
                    ent.curSearcher = ent.newSearcher;
                    ent.newSearcher = null;
                    Trace.untab();
                    Trace.info("Done.");
                }
            }
            catch (Throwable exc) {
                ent.exception = exc;
                ent.exceptionTime = System.currentTimeMillis();
                Trace.untab();
                Trace.error(String.format("Error warming index '%s': %s", ent.indexPath, exc.toString()));
            }
        }
    }

    private static class Entry {
        String indexPath;
        File currentPath;
        File pendingPath;
        File sparePath;
        File newPath;
        XtfSearcher curSearcher;
        XtfSearcher newSearcher;
        Throwable exception;
        long exceptionTime;

        Entry(String indexPath) {
            this.indexPath = indexPath;
            this.currentPath = new File(indexPath);
            File parentDir = this.currentPath.getParentFile();
            this.newPath = new File(parentDir, String.valueOf(this.currentPath.getName()) + "-new");
            this.sparePath = new File(parentDir, String.valueOf(this.currentPath.getName()) + "-spare");
            this.pendingPath = new File(parentDir, String.valueOf(this.currentPath.getName()) + "-pending");
        }
    }
}

