/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import net.sf.saxon.Filter;
import net.sf.saxon.TransformerFactoryImpl;
import org.cdlib.xtf.saxonExt.sql.SQLConnect;
import org.cdlib.xtf.textEngine.ConfigCache;
import org.cdlib.xtf.textIndexer.CrimsonBugWorkaround;
import org.cdlib.xtf.textIndexer.IndexInfo;
import org.cdlib.xtf.textIndexer.IndexerConfig;
import org.cdlib.xtf.util.DocTypeDeclRemover;
import org.cdlib.xtf.util.Path;
import org.cdlib.xtf.util.XTFSaxonErrorListener;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class IndexUtil {
    private static ConfigCache configCache = new ConfigCache();
    private static SAXParserFactory saxParserFactory = null;
    private static TransformerFactory transformerFactory = null;

    public static IndexInfo getIndexInfo(File idxConfigFile, String idxName) throws Exception {
        return IndexUtil.configCache.find((File)idxConfigFile, (String)idxName).indexInfo;
    }

    public static File calcLazyPath(File xtfHome, File idxConfigFile, String idxName, File srcTextFile, boolean createDir) throws IOException {
        IndexerConfig idxCfg;
        try {
            idxCfg = configCache.find(idxConfigFile, idxName);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new RuntimeException(e);
        }
        if (idxCfg.indexInfo == null || idxCfg.indexInfo.sourcePath == null) {
            throw new RuntimeException("Index name '" + idxName + "' not found in index config file");
        }
        return IndexUtil.calcLazyPath(xtfHome, idxCfg.indexInfo, srcTextFile, createDir);
    }

    public static File calcLazyPath(File xtfHome, IndexInfo idxInfo, File srcTextFile, boolean createDir) throws IOException {
        String sourcePath = idxInfo.cloneData && srcTextFile.toString().contains("/dataClone/") ? String.valueOf(Path.normalizePath(idxInfo.indexPath)) + "dataClone/" + idxInfo.indexName + "/" : idxInfo.sourcePath;
        String fullSourcePath = Path.resolveRelOrAbs(xtfHome.toString(), sourcePath);
        String prefix = Path.calcPrefix(srcTextFile.getParent(), fullSourcePath.toString());
        if (prefix == null) {
            throw new IOException("XML source file " + srcTextFile + " is not contained within " + idxInfo.sourcePath);
        }
        String srcTextPath = Path.normalizeFileName(srcTextFile.toString());
        String after = srcTextPath.substring(prefix.length());
        String lazyPath = String.valueOf(idxInfo.indexPath) + "lazy/" + idxInfo.indexName + "/" + after + ".lazy";
        lazyPath = Path.resolveRelOrAbs(xtfHome.toString(), lazyPath);
        File lazyFile = new File(lazyPath);
        if (createDir && !Path.createPath(lazyFile.getParentFile().toString())) {
            throw new IOException("Error creating lazy file path");
        }
        return lazyFile;
    }

    public static String calcDocKey(File xtfHome, File idxConfigFile, String idxName, File srcTextFile) throws IOException {
        IndexerConfig config;
        try {
            config = configCache.find(idxConfigFile, idxName);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new RuntimeException(e);
        }
        return IndexUtil.calcDocKey(xtfHome, config.indexInfo, srcTextFile);
    }

    public static String calcDocKey(File xtfHomeFile, IndexInfo idxInfo, File srcTextFile) throws IOException {
        String sourcePath = idxInfo.cloneData && srcTextFile.toString().contains("/dataClone/") ? String.valueOf(Path.normalizePath(idxInfo.indexPath)) + "dataClone/" + idxInfo.indexName + "/" : idxInfo.sourcePath;
        String fullSourcePath = Path.resolveRelOrAbs(xtfHomeFile, sourcePath);
        String prefix = Path.calcPrefix(srcTextFile.getParent(), fullSourcePath);
        if (prefix == null) {
            throw new IOException("XML source file " + srcTextFile + " is not contained within " + sourcePath);
        }
        String srcTextPath = Path.normalizeFileName(srcTextFile.toString());
        String after = srcTextPath.substring(prefix.length());
        String key = String.valueOf(idxInfo.indexName) + ":" + after;
        return key;
    }

    public static SAXParser createSAXParser() {
        if (saxParserFactory == null) {
            try {
                Class<?> factoryClass = Class.forName("com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
                saxParserFactory = (SAXParserFactory)factoryClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                try {
                    Class<?> factoryClass = Class.forName("org.apache.crimson.jaxp.SAXParserFactoryImpl");
                    saxParserFactory = (SAXParserFactory)factoryClass.newInstance();
                }
                catch (ClassNotFoundException e2) {
                    saxParserFactory = SAXParserFactory.newInstance();
                }
                catch (InstantiationException e2) {
                    throw new RuntimeException(e2);
                }
                catch (IllegalAccessException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        SAXParserFactory sAXParserFactory = saxParserFactory;
        synchronized (sAXParserFactory) {
            try {
                SAXParser xmlParser = saxParserFactory.newSAXParser();
                XMLReader xmlReader = xmlParser.getXMLReader();
                xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
                xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
                try {
                    xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                }
                catch (SAXException sAXException) {
                    // empty catch block
                }
                return xmlParser;
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static XMLReader createXMLReader() {
        try {
            SAXParser parser = IndexUtil.createSAXParser();
            return parser.getXMLReader();
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private static TransformerFactory getTransformerFactory() {
        if (transformerFactory == null) {
            transformerFactory = new TransformerFactoryImpl();
        }
        return transformerFactory;
    }

    public static Transformer createTransformer() {
        try {
            return IndexUtil.getTransformerFactory().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream filterXMLDocument(InputStream inStream, boolean applyCrimsonWorkaround, boolean removeDoctypeDecl) {
        if (removeDoctypeDecl) {
            inStream = new DocTypeDeclRemover(inStream);
        }
        if (applyCrimsonWorkaround) {
            inStream = new CrimsonBugWorkaround(inStream);
        }
        return inStream;
    }

    public static InputStream filterXMLDocument(InputStream inStream, SAXParser saxParser, boolean removeDoctypeDecl) {
        boolean applyCrimsonWorkaround = saxParser.getClass().getName().equals("org.apache.crimson.jaxp.SAXParserImpl");
        return IndexUtil.filterXMLDocument(inStream, applyCrimsonWorkaround, removeDoctypeDecl);
    }

    public static void applyPreFilters(Templates[] prefilterStylesheets, XMLReader reader, InputSource xmlSource, Result ultimateResult) throws SAXException, TransformerException, TransformerConfigurationException {
        assert (prefilterStylesheets.length > 0) : "applyPrefilters must have at least one stylesheet";
        XMLReader lastInChain = reader;
        SAXTransformerFactory stf = (SAXTransformerFactory)IndexUtil.getTransformerFactory();
        int i = 0;
        while (i < prefilterStylesheets.length) {
            Filter filter = (Filter)stf.newXMLFilter(prefilterStylesheets[i]);
            Transformer trans = filter.getTransformer();
            if (!(trans.getErrorListener() instanceof XTFSaxonErrorListener)) {
                trans.setErrorListener(new XTFSaxonErrorListener());
            }
            filter.setParent(lastInChain);
            lastInChain = filter;
            ++i;
        }
        Transformer transformer = stf.newTransformer();
        SAXSource transformSource = new SAXSource(lastInChain, xmlSource);
        transformer.transform(transformSource, ultimateResult);
        SQLConnect.closeThreadConnections();
    }
}

