/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.lazyTree;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import org.cdlib.xtf.lazyTree.ElementImpl;
import org.cdlib.xtf.lazyTree.NodeImpl;

final class AttributeImpl
extends NodeImpl {
    ElementImpl element;
    int index;

    public AttributeImpl(ElementImpl element, int index) {
        this.document = element.document;
        this.index = index;
        this.element = element;
        this.nameCode = element.attrNames[index];
    }

    public NodeInfo getRoot() {
        return this.element.document.getRoot();
    }

    public DocumentInfo getDocumentRoot() {
        return this.element.document.getDocumentRoot();
    }

    public NamePool getNamePool() {
        return this.element.document.getNamePool();
    }

    public boolean isSameNodeInfo(NodeInfo other) {
        if (!(other instanceof AttributeImpl)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        AttributeImpl otherAtt = (AttributeImpl)other;
        return this.element.isSameNodeInfo(otherAtt.element) && this.index == otherAtt.index;
    }

    public int hashCode() {
        return this.element.hashCode() ^ this.getFingerprint();
    }

    protected long getSequenceNumber() {
        return this.element.getSequenceNumber() + 32768L + (long)this.index;
    }

    public final int getNodeKind() {
        return 2;
    }

    public String getStringValue() {
        return this.element.attrValues[this.index];
    }

    public NodeInfo getNextSibling() {
        return null;
    }

    public NodeInfo getPreviousSibling() {
        return null;
    }

    public NodeImpl getPreviousInDocument() {
        return (NodeImpl)this.getParent();
    }

    public void generateId(FastStringBuffer buffer) {
        this.getParent().generateId(buffer);
        buffer.append('a');
        buffer.append(Integer.toString(this.index));
    }

    public String getDisplayName() {
        if (this.getNameCode() < 0) {
            return "";
        }
        return this.getNamePool().getDisplayName(this.getNameCode());
    }

    public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        int nameCode = this.getNameCode();
        out.attribute(nameCode, -1, this.getStringValue(), 0, 0);
    }
}

