/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.lucene.util.ProgressTracker;

public class ProgressTrackerTest
extends TestCase {
    public void testSingle() {
        TestTracker tracker = new TestTracker();
        tracker.setMinInterval(0x3FFFFFFF);
        tracker.progress(0L, 100L, "start");
        tracker.progress(10L, 100L, "midway 1", true);
        tracker.progress(20L, 100L, "midway 2");
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        tracker.progress(40L, 100L, "midway 3");
        tracker.progress(60L, 100L, "midway 4");
        tracker.progress(80L, 100L, "midway 5", true);
        tracker.progress(90L, 100L, "ending");
        tracker.progress(100L, 100L, "end", true);
        ProgressTrackerTest.assertEquals((String)tracker.list.get(0), (String)"0% start");
        ProgressTrackerTest.assertEquals((String)tracker.list.get(1), (String)"10% midway 1");
        ProgressTrackerTest.assertEquals((String)tracker.list.get(2), (String)"80% midway 5");
        ProgressTrackerTest.assertEquals((String)tracker.list.get(3), (String)"100% end");
    }

    private class TestTracker
    extends ProgressTracker {
        ArrayList<String> list = new ArrayList();

        private TestTracker() {
        }

        public void report(int pctDone, String descrip) {
            this.list.add(String.valueOf(pctDone) + "% " + descrip);
        }
    }
}

