/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CountedInputStream
extends FilterInputStream {
    private long nRead = 0L;

    public CountedInputStream(InputStream in) {
        super(in);
    }

    public long nRead() {
        return this.nRead;
    }

    public int read() throws IOException {
        int retVal = this.in.read();
        if (retVal >= 0) {
            ++this.nRead;
        }
        return retVal;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int retVal = this.in.read(b, off, len);
        if (retVal >= 0) {
            this.nRead += (long)retVal;
        }
        return retVal;
    }

    public long skip(long n) throws IOException {
        long retVal = this.in.skip(n);
        if (retVal >= 0L) {
            this.nRead += retVal;
        }
        return retVal;
    }

    public boolean markSupported() {
        return false;
    }
}

