/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spelt;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.spelt.SpellWriter;
import org.apache.lucene.spelt.SpellWritingFilter;

public class SpellWritingAnalyzer
extends Analyzer {
    private Set stopSet;
    private SpellWriter writer;
    public static final String[] STOP_WORDS = StopAnalyzer.ENGLISH_STOP_WORDS;

    public SpellWritingAnalyzer(SpellWriter spellWriter) {
        this(StandardAnalyzer.STOP_WORDS, spellWriter);
    }

    public SpellWritingAnalyzer(Set stopWords, SpellWriter spellWriter) {
        this.stopSet = stopWords;
        this.writer = spellWriter;
        this.writer.setStopwords(stopWords);
    }

    public SpellWritingAnalyzer(String[] stopWords, SpellWriter spellWriter) {
        this(StopFilter.makeStopSet(stopWords), spellWriter);
    }

    public SpellWritingAnalyzer(File stopwords, SpellWriter spellWriter) throws IOException {
        this(WordlistLoader.getWordSet(stopwords), spellWriter);
    }

    public SpellWritingAnalyzer(Reader stopwords, SpellWriter spellWriter) throws IOException {
        this(WordlistLoader.getWordSet(stopwords), spellWriter);
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream result = new StandardTokenizer(reader);
        result = new StandardFilter(result);
        result = new SpellWritingFilter(result, this.writer);
        result = new LowerCaseFilter(result);
        result = new StopFilter(result, this.stopSet);
        return result;
    }
}

