/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.Graphics2DAdapter;
import org.apache.fop.render.Graphics2DImagePainter;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.RendererContextConstants;
import org.apache.fop.render.XMLHandler;
import org.apache.fop.svg.SVGUserAgent;
import org.w3c.dom.Document;

public abstract class AbstractGenericSVGHandler
implements XMLHandler,
RendererContextConstants {
    private static Log log = LogFactory.getLog((Class)AbstractGenericSVGHandler.class);

    public void handleXML(RendererContext context, Document doc, String ns) throws Exception {
        if ("http://www.w3.org/2000/svg".equals(ns)) {
            this.renderSVGDocument(context, doc);
        }
    }

    protected void renderSVGDocument(RendererContext context, Document doc) throws IOException {
        GraphicsNode root;
        this.updateRendererContext(context);
        final RendererContext.RendererContextWrapper wrappedContext = RendererContext.wrapRendererContext(context);
        int x = wrappedContext.getCurrentXPosition();
        int y = wrappedContext.getCurrentYPosition();
        SVGUserAgent ua = new SVGUserAgent(context.getUserAgent().getSourcePixelUnitToMillimeter(), new AffineTransform());
        GVTBuilder builder = new GVTBuilder();
        final BridgeContext ctx = new BridgeContext(ua);
        try {
            root = builder.build(ctx, doc);
        }
        catch (Exception e) {
            log.error((Object)("SVG graphic could not be built: " + e.getMessage()), (Throwable)e);
            return;
        }
        Graphics2DImagePainter painter = new Graphics2DImagePainter(){

            public void paint(Graphics2D g2d, Rectangle2D area) {
                float iw = (float)ctx.getDocumentSize().getWidth();
                float ih = (float)ctx.getDocumentSize().getHeight();
                float w = (float)area.getWidth();
                float h = (float)area.getHeight();
                g2d.scale(w / iw, h / ih);
                root.paint(g2d);
            }

            public Dimension getImageSize() {
                return new Dimension(wrappedContext.getWidth(), wrappedContext.getHeight());
            }
        };
        Graphics2DAdapter adapter = context.getRenderer().getGraphics2DAdapter();
        adapter.paintImage(painter, context, x, y, wrappedContext.getWidth(), wrappedContext.getHeight());
    }

    protected void updateRendererContext(RendererContext context) {
    }

    public String getNamespace() {
        return "http://www.w3.org/2000/svg";
    }
}

