/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.util.Iterator;
import java.util.TreeSet;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Module;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.ValueSequence;

public class BuiltinFunctions
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("registered-functions", "http://exist-db.org/xquery/util", "util"), "Returns a sequence containing the QNames of all functions declared in the module identified by the specified namespace URI. An error is raised if no module is found for the specified URI.", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(22, 6)), new FunctionSignature(new QName("registered-functions", "http://exist-db.org/xquery/util", "util"), "Returns a sequence containing the QNames of all functions currently known to the system, including functions in imported and built-in modules.", null, new SequenceType(22, 6))};

    public BuiltinFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        ValueSequence resultSeq = new ValueSequence();
        if (this.getSignature().getArgumentCount() == 1) {
            String uri = args[0].getStringValue();
            Module module = this.context.getModule(uri);
            if (module == null) {
                throw new XPathException(this.getASTNode(), "No module found matching namespace URI: " + uri);
            }
            this.addFunctionsFromModule(resultSeq, module);
        } else {
            Iterator i = this.context.getModules();
            while (i.hasNext()) {
                Module module = (Module)i.next();
                this.addFunctionsFromModule(resultSeq, module);
            }
            i = this.context.localFunctions();
            while (i.hasNext()) {
                UserDefinedFunction func = (UserDefinedFunction)i.next();
                FunctionSignature sig = func.getSignature();
                resultSeq.add(new QNameValue(this.context, sig.getName()));
            }
        }
        return resultSeq;
    }

    private void addFunctionsFromModule(ValueSequence resultSeq, Module module) {
        QName qname;
        TreeSet<QName> set = new TreeSet<QName>();
        FunctionSignature[] signatures = module.listFunctions();
        for (int j = 0; j < signatures.length; ++j) {
            qname = signatures[j].getName();
            set.add(qname);
        }
        Iterator it = set.iterator();
        while (it.hasNext()) {
            qname = (QName)it.next();
            resultSeq.add(new QNameValue(this.context, qname));
        }
    }
}

