/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.system;

import java.util.ArrayList;
import java.util.List;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.storage.analysis.TextToken;
import org.exist.storage.analysis.Tokenizer;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.DynamicCardinalityCheck;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.Error;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FtIndexLookup
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("ft-index-lookup", "http://exist-db.org/xquery/system", "system"), "Internal function", new SequenceType[]{new SequenceType(-1, 7), new SequenceType(22, 3)}, new SequenceType(-1, 7));

    public FtIndexLookup(XQueryContext context) {
        super(context, signature);
    }

    public int getDependencies() {
        return 1;
    }

    public void setArguments(List arguments) throws XPathException {
        Expression arg = (Expression)arguments.get(0);
        arg = new DynamicCardinalityCheck(this.context, 7, arg, new Error("D02", "1", this.mySignature));
        this.steps.add(arg);
        arg = (Expression)arguments.get(1);
        arg = new DynamicCardinalityCheck(this.context, 7, arg, new Error("D02", "2", this.mySignature));
        this.steps.add(arg);
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.inPredicate = (contextInfo.getFlags() & 2) > 0;
        for (int i = 0; i < this.getArgumentCount(); ++i) {
            this.getArgument(i).analyze(contextInfo);
        }
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence querySeq = this.getArgument(1).eval(contextSequence);
        if (querySeq.isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String query = querySeq.itemAt(0).getStringValue();
        String[] terms = this.getSearchTerms(query);
        NodeSet[] hits = new NodeSet[terms.length];
        NodeSet contextSet = contextSequence.toNodeSet();
        for (int k = 0; k < terms.length; ++k) {
            hits[k] = this.context.getBroker().getTextEngine().getNodesContaining(this.context, contextSet.getDocumentSet(), null, 1, null, terms[k], 0);
            hits[k] = this.getArgument(0).eval(hits[k]).toNodeSet();
        }
        NodeSet result = hits[0];
        for (int k = 1; k < hits.length; ++k) {
            if (hits[k] == null) continue;
            result = result.deepIntersection(hits[k]);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("FOUND: " + result.getLength()));
        }
        return result;
    }

    protected String[] getSearchTerms(String searchString) {
        TextToken token;
        ArrayList<String> tokens = new ArrayList<String>();
        Tokenizer tokenizer = this.context.getBroker().getTextEngine().getTokenizer();
        tokenizer.setText(searchString);
        while (null != (token = tokenizer.nextToken(true))) {
            String word = token.getText();
            tokens.add(word);
        }
        String[] terms = new String[tokens.size()];
        terms = tokens.toArray(terms);
        return terms;
    }
}

