/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.FunMatches;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class FunTokenize
extends FunMatches {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("tokenize", "http://www.w3.org/2005/xpath-functions"), "This function breaks the input string $a into a sequence of strings, treating any substring that matches pattern $b as a separator. The separators themselves are not returned.", new SequenceType[]{new SequenceType(22, 3), new SequenceType(22, 2)}, new SequenceType(22, 6)), new FunctionSignature(new QName("tokenize", "http://www.w3.org/2005/xpath-functions"), "This function breaks the input string $a into a sequence of strings, treating any substring that matches pattern $b as a separator. The separators themselves are not returned.", new SequenceType[]{new SequenceType(22, 3), new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(22, 6))};

    public FunTokenize(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        Sequence stringArg;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ((stringArg = this.getArgument(0).eval(contextSequence, contextItem)).isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            String string = stringArg.getStringValue();
            if (string.length() == 0) {
                result = Sequence.EMPTY_SEQUENCE;
            } else {
                String pattern = this.translateRegexp(this.getArgument(1).eval(contextSequence, contextItem).getStringValue());
                if (Pattern.matches(pattern, "")) {
                    throw new XPathException("FORX0003: regular expression could match empty string");
                }
                int flags = 0;
                if (this.getSignature().getArgumentCount() == 3) {
                    flags = FunTokenize.parseFlags(this.getArgument(2).eval(contextSequence, contextItem).getStringValue());
                }
                try {
                    if (this.pat == null || !pattern.equals(this.pat.pattern()) || flags != this.pat.flags()) {
                        this.pat = Pattern.compile(pattern, flags);
                    }
                    String[] tokens = this.pat.split(string, -1);
                    result = new ValueSequence();
                    for (int i = 0; i < tokens.length; ++i) {
                        result.add(new StringValue(tokens[i]));
                    }
                }
                catch (PatternSyntaxException e) {
                    throw new XPathException(this.getASTNode(), "Invalid regular expression: " + e.getMessage(), e);
                }
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

