/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Stack;
import org.apache.log4j.Logger;
import org.exist.xquery.Expression;
import org.exist.xquery.Option;
import org.exist.xquery.parser.XQueryAST;
import org.exist.xquery.value.Sequence;

public class Profiler {
    private Logger log = Logger.getLogger((String)"xquery.profiling");
    private Stack stack = new Stack();
    private final StringBuffer buf = new StringBuffer(64);
    private boolean enabled = false;
    private int verbosity = 0;
    public static int TIME = 1;
    public static int OPTIMIZATIONS = 2;
    public static int OPTIMIZATION_FLAGS = 3;
    public static int DEPENDENCIES = 4;
    public static int START_SEQUENCES = 4;
    public static int ITEM_COUNT = 5;
    public static int SEQUENCE_PREVIEW = 6;
    public static int SEQUENCE_DUMP = 8;

    public final void configure(Option pragma) {
        String[] options = pragma.tokenizeContents();
        for (int i = 0; i < options.length; ++i) {
            String[] params = Option.parseKeyValuePair(options[i]);
            if (params == null) continue;
            if (params[0].equals("logger")) {
                this.log = Logger.getLogger((String)params[1]);
                continue;
            }
            if (params[0].equals("enabled")) {
                this.enabled = params[1].equals("yes");
                continue;
            }
            if ("verbosity".equals(params[0])) {
                try {
                    this.verbosity = Integer.parseInt(params[1]);
                }
                catch (NumberFormatException e) {
                    this.log.warn((Object)("invalid value for verbosity: should be an integer between 0 and " + SEQUENCE_DUMP));
                }
                continue;
            }
            this.log.warn((Object)"invalid parameter for  declare option exist:profiling : should be enabled verbosity , or logger");
        }
        if (this.verbosity == 0) {
            this.enabled = false;
        }
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final int verbosity() {
        return this.verbosity;
    }

    public final void start(Expression expr) {
        this.start(expr, null);
    }

    public final void start(Expression expr, String message) {
        if (!this.enabled) {
            return;
        }
        if (this.stack.size() == 0) {
            this.log.debug((Object)"QUERY START");
        }
        this.buf.setLength(0);
        for (int i = 0; i < this.stack.size(); ++i) {
            this.buf.append('\t');
        }
        ProfiledExpr e = new ProfiledExpr(expr);
        this.stack.push(e);
        this.buf.append("START\t");
        this.printPosition(e.expr);
        this.buf.append(expr.toString());
        this.log.debug((Object)this.buf.toString());
        if (message != null && !"".equals(message)) {
            this.buf.setLength(0);
            for (int i = 0; i < this.stack.size(); ++i) {
                this.buf.append('\t');
            }
            this.buf.append("MSG\t");
            this.buf.append(message);
            this.buf.append("\t");
            this.printPosition(e.expr);
            this.buf.append(expr.toString());
            this.log.debug((Object)this.buf.toString());
        }
    }

    public final void end(Expression expr, String message, Sequence result) {
        if (!this.enabled) {
            return;
        }
        try {
            int i;
            ProfiledExpr e = (ProfiledExpr)this.stack.pop();
            if (e.expr != expr) {
                this.log.warn((Object)"Error: the object passed to end() does not correspond to the expression on top of the stack.");
                this.stack.clear();
                return;
            }
            long elapsed = System.currentTimeMillis() - e.start;
            if (message != null && !"".equals(message)) {
                this.buf.setLength(0);
                for (i = 0; i < this.stack.size(); ++i) {
                    this.buf.append('\t');
                }
                this.buf.append("MSG\t");
                this.buf.append(message);
                this.buf.append("\t");
                this.printPosition(e.expr);
                this.buf.append(expr.toString());
                this.log.debug((Object)this.buf.toString());
            }
            if (this.verbosity > START_SEQUENCES) {
                this.buf.setLength(0);
                for (i = 0; i < this.stack.size(); ++i) {
                    this.buf.append('\t');
                }
                this.buf.append("RESULT\t");
                if (this.verbosity >= ITEM_COUNT) {
                    this.buf.append(result.getItemCount() + " item(s)");
                }
                this.buf.append("\t");
                this.printPosition(e.expr);
                this.buf.append(expr.toString());
                this.log.debug((Object)this.buf.toString());
            }
            if (this.verbosity >= TIME) {
                this.buf.setLength(0);
                for (i = 0; i < this.stack.size(); ++i) {
                    this.buf.append('\t');
                }
                this.buf.append("TIME\t");
                this.buf.append(elapsed + " ms");
                this.buf.append("\t");
                this.printPosition(e.expr);
                this.buf.append(expr.toString());
                this.log.debug((Object)this.buf.toString());
            }
            this.buf.setLength(0);
            for (i = 0; i < this.stack.size(); ++i) {
                this.buf.append('\t');
            }
            this.buf.append("END\t");
            this.printPosition(e.expr);
            this.buf.append(expr.toString());
            this.log.debug((Object)this.buf.toString());
            if (this.stack.size() == 0) {
                this.log.debug((Object)"QUERY END");
            }
        }
        catch (RuntimeException e) {
            this.log.debug((Object)("Profiler: could not pop from expression stack - " + expr + " - " + message + ". Error : " + e.getMessage()));
        }
    }

    public final void message(Expression expr, int level, String title, Sequence sequence) {
        if (!this.enabled) {
            return;
        }
        if (level > this.verbosity) {
            return;
        }
        this.buf.setLength(0);
        for (int i = 0; i < this.stack.size() - 1; ++i) {
            this.buf.append('\t');
        }
        if (title != null && !"".equals(title)) {
            this.buf.append(title);
        } else {
            this.buf.append("MSG");
        }
        this.buf.append("\t");
        if (this.verbosity >= ITEM_COUNT) {
            this.buf.append(sequence.getItemCount() + " item(s)");
        }
        this.buf.append("\t");
        this.buf.append(expr.toString());
        this.log.debug((Object)this.buf.toString());
    }

    public final void message(Expression expr, int level, String title, String message) {
        if (!this.enabled) {
            return;
        }
        if (level > this.verbosity) {
            return;
        }
        this.buf.setLength(0);
        for (int i = 0; i < this.stack.size() - 1; ++i) {
            this.buf.append('\t');
        }
        if (title != null && !"".equals(title)) {
            this.buf.append(title);
        } else {
            this.buf.append("MSG");
        }
        if (message != null && !"".equals(message)) {
            this.buf.append("\t");
            this.buf.append(message);
        }
        this.buf.append("\t");
        this.printPosition(expr);
        this.buf.append(expr.toString());
        this.log.debug((Object)this.buf.toString());
    }

    public void reset() {
        if (this.stack.size() > 0) {
            this.log.debug((Object)"QUERY RESET");
        }
        this.stack.clear();
    }

    private void printPosition(Expression expr) {
        XQueryAST ast = expr.getASTNode();
        if (ast != null) {
            this.buf.append('[');
            this.buf.append(ast.getColumn());
            this.buf.append(',');
            this.buf.append(ast.getLine());
            this.buf.append("]\t");
        } else {
            this.buf.append("\t");
        }
    }

    private String sequencePreview(Sequence sequence) {
        StringBuffer truncation = new StringBuffer();
        if (sequence.isEmpty()) {
            truncation.append(sequence.toString());
        } else if (sequence.hasOne()) {
            truncation.append("(");
            if (sequence.itemAt(0).toString().length() > 20) {
                truncation.append(sequence.itemAt(0).toString().substring(0, 20)).append("... ");
            } else {
                truncation.append(sequence.itemAt(0).toString());
            }
            truncation.append(")");
        } else {
            truncation.append("(");
            if (sequence.itemAt(0).toString().length() > 20) {
                truncation.append(sequence.itemAt(0).toString().substring(0, 20)).append("... ");
            } else {
                truncation.append(sequence.itemAt(0).toString());
            }
            truncation.append(", ... )");
        }
        return truncation.toString();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setVerbosity(int verbosity) {
        this.verbosity = verbosity;
    }

    private static final class ProfiledExpr {
        long start;
        Expression expr;

        private ProfiledExpr(Expression expression) {
            this.expr = expression;
            this.start = System.currentTimeMillis();
        }
    }
}

