/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.TreeSet;
import org.exist.dom.ContextItem;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.NodeSetIterator;
import org.exist.dom.VirtualNodeSet;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.CachedResult;
import org.exist.xquery.Cardinality;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.GeneralComparison;
import org.exist.xquery.PathExpr;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class Predicate
extends PathExpr {
    private static final int UNKNOWN = -1;
    private static final int NODE = 0;
    private static final int BOOLEAN = 1;
    private static final int POSITIONAL = 2;
    private CachedResult cached = null;
    private int executionMode = -1;
    private int outerContextId;
    private Expression parent;

    public Predicate(XQueryContext context) {
        super(context);
    }

    public int getDependencies() {
        int deps = 0;
        deps = this.getLength() == 1 ? this.getExpression(0).getDependencies() : super.getDependencies();
        return deps;
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        this.parent = contextInfo.getParent();
        AnalyzeContextInfo newContextInfo = this.createContext(contextInfo);
        super.analyze(newContextInfo);
        Expression inner = this.getExpression(0);
        int innerType = inner.returnsType();
        this.executionMode = Type.subTypeOf(innerType, -1) && !Dependency.dependsOn(inner, 2) ? 0 : (Type.subTypeOf(innerType, 30) && !Dependency.dependsOn(inner, 2) && Cardinality.checkCardinality(inner.getCardinality(), 2) ? 2 : 1);
        if (this.executionMode == 1) {
            newContextInfo = this.createContext(contextInfo);
            newContextInfo.addFlag(1);
            super.analyze(newContextInfo);
        }
    }

    private AnalyzeContextInfo createContext(AnalyzeContextInfo contextInfo) {
        AnalyzeContextInfo newContextInfo = new AnalyzeContextInfo(contextInfo);
        newContextInfo.addFlag(2);
        newContextInfo.removeFlag(4);
        newContextInfo.removeFlag(128);
        this.outerContextId = newContextInfo.getContextId();
        newContextInfo.setContextId(this.getExpressionId());
        newContextInfo.setStaticType(contextInfo.getStaticType());
        newContextInfo.setParent(this);
        return newContextInfo;
    }

    public Sequence evalPredicate(Sequence outerSequence, Sequence contextSequence, int mode) throws XPathException {
        Sequence result;
        Expression inner;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        if ((inner = this.getExpression(0)) == null) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            int recomputedExecutionMode = this.executionMode;
            Sequence innerSeq = null;
            if (Type.subTypeOf(contextSequence.getItemType(), 20)) {
                if (this.executionMode == 0 && !(contextSequence instanceof VirtualNodeSet)) {
                    recomputedExecutionMode = Type.subTypeOf(contextSequence.getItemType(), 30) ? 2 : 1;
                }
                if (!(this.executionMode != 1 || Dependency.dependsOn(inner, 2) || inner instanceof GeneralComparison && ((GeneralComparison)inner).invalidNodeEvaluation || !(innerSeq = inner.eval(contextSequence)).hasOne() || !Type.subTypeOf(innerSeq.getItemType(), 30))) {
                    recomputedExecutionMode = 2;
                }
            } else if (this.executionMode == 1 && !Dependency.dependsOn(inner, 2)) {
                innerSeq = inner.eval(contextSequence);
                if (Type.subTypeOf(innerSeq.getItemType(), -1)) {
                    recomputedExecutionMode = 0;
                } else if (innerSeq.hasOne() && Type.subTypeOf(innerSeq.getItemType(), 30)) {
                    recomputedExecutionMode = 2;
                }
            }
            switch (recomputedExecutionMode) {
                case 0: {
                    if (this.context.getProfiler().isEnabled()) {
                        this.context.getProfiler().message((Expression)this, Profiler.OPTIMIZATION_FLAGS, "OPTIMIZATION CHOICE", "Node selection");
                    }
                    result = this.selectByNodeSet(contextSequence);
                    break;
                }
                case 1: {
                    if (this.context.getProfiler().isEnabled()) {
                        this.context.getProfiler().message((Expression)this, Profiler.OPTIMIZATION_FLAGS, "OPTIMIZATION CHOICE", "Boolean evaluation");
                    }
                    result = this.evalBoolean(contextSequence, inner);
                    break;
                }
                case 2: {
                    if (this.context.getProfiler().isEnabled()) {
                        this.context.getProfiler().message((Expression)this, Profiler.OPTIMIZATION_FLAGS, "OPTIMIZATION CHOICE", "Positional evaluation");
                    }
                    if (innerSeq == null) {
                        innerSeq = inner.eval(contextSequence);
                    }
                    result = this.selectByPosition(outerSequence, contextSequence, mode, innerSeq);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported execution mode: '" + recomputedExecutionMode + "'");
                }
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    private Sequence evalBoolean(Sequence contextSequence, Expression inner) throws XPathException {
        ValueSequence result = new ValueSequence();
        if (contextSequence instanceof NodeSet && ((NodeSet)contextSequence).getProcessInReverseOrder()) {
            int p = contextSequence.getItemCount();
            SequenceIterator i = contextSequence.iterate();
            while (i.hasNext()) {
                this.context.setContextPosition(p - 1);
                Item item = i.nextItem();
                Sequence innerSeq = inner.eval(contextSequence, item);
                if (innerSeq.effectiveBooleanValue()) {
                    result.add(item);
                }
                --p;
            }
        } else {
            int p = 0;
            if (Type.subTypeOf(inner.returnsType(), 30) && Dependency.dependsOn(inner, 2)) {
                TreeSet<NumericValue> positions = new TreeSet<NumericValue>();
                Object i = contextSequence.iterate();
                while (i.hasNext()) {
                    this.context.setContextPosition(p);
                    Item item = i.nextItem();
                    Sequence innerSeq = inner.eval(contextSequence, item);
                    NumericValue nv = (NumericValue)innerSeq.itemAt(0);
                    if (!nv.hasFractionalPart() && !nv.isZero()) {
                        positions.add(nv);
                    }
                    ++p;
                }
                i = positions.iterator();
                while (i.hasNext()) {
                    int position = ((NumericValue)i.next()).getInt();
                    if (position > contextSequence.getItemCount()) continue;
                    result.add(contextSequence.itemAt(position - 1));
                }
            } else {
                TreeSet<NumericValue> positions = new TreeSet<NumericValue>();
                Object i = contextSequence.iterate();
                while (i.hasNext()) {
                    this.context.setContextPosition(p);
                    Item item = i.nextItem();
                    Sequence innerSeq = inner.eval(contextSequence, item);
                    if (innerSeq.hasOne() && Type.subTypeOf(innerSeq.getItemType(), 30)) {
                        NumericValue nv = (NumericValue)innerSeq;
                        if (!nv.hasFractionalPart() && !nv.isZero()) {
                            positions.add(nv);
                        }
                    } else if (innerSeq.effectiveBooleanValue()) {
                        result.add(item);
                    }
                    ++p;
                }
                i = positions.iterator();
                while (i.hasNext()) {
                    int position = ((NumericValue)i.next()).getInt();
                    if (position > contextSequence.getItemCount()) continue;
                    result.add(contextSequence.itemAt(position - 1));
                }
            }
        }
        return result;
    }

    private Sequence selectByNodeSet(Sequence contextSequence) throws XPathException {
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        NodeSet contextSet = contextSequence.toNodeSet();
        boolean contextIsVirtual = contextSet instanceof VirtualNodeSet;
        NodeSet nodes = super.eval(contextSet, null).toNodeSet();
        if (this.cached != null && this.cached.isValid(contextSequence, null) && nodes.isCached()) {
            if (this.context.getProfiler().isEnabled()) {
                this.context.getProfiler().message((Expression)this, Profiler.OPTIMIZATIONS, "Using cached results", result);
            }
            return this.cached.getResult();
        }
        DocumentImpl lastDoc = null;
        NodeSetIterator i = nodes.iterator();
        while (i.hasNext()) {
            ContextItem contextItem;
            NodeProxy currentNode = (NodeProxy)i.next();
            int sizeHint = -1;
            if (lastDoc == null || currentNode.getDocument() != lastDoc) {
                lastDoc = currentNode.getDocument();
                sizeHint = nodes.getSizeHint(lastDoc);
            }
            if ((contextItem = currentNode.getContext()) == null) {
                throw new XPathException("Internal evaluation error: context is missing for node " + currentNode.getNodeId() + " !");
            }
            while (contextItem != null) {
                if (contextItem.getContextId() == this.getExpressionId()) {
                    NodeProxy next = contextItem.getNode();
                    if (contextIsVirtual || contextSet.contains(next)) {
                        next.addMatches(currentNode);
                        result.add(next, sizeHint);
                    }
                }
                contextItem = contextItem.getNextDirect();
            }
        }
        if (contextSequence instanceof NodeSet) {
            this.cached = new CachedResult((NodeSet)contextSequence, null, result);
        }
        return result;
    }

    private Sequence selectByPosition(Sequence outerSequence, Sequence contextSequence, int mode, Sequence innerSeq) throws XPathException {
        if (outerSequence != null && !outerSequence.isEmpty() && Type.subTypeOf(contextSequence.getItemType(), -1)) {
            ExtArrayNodeSet result = new ExtArrayNodeSet(100);
            NodeSet contextSet = contextSequence.toNodeSet();
            switch (mode) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 13: {
                    NodeSet outerNodeSet;
                    if (outerSequence instanceof VirtualNodeSet) {
                        outerNodeSet = new ExtArrayNodeSet();
                        for (int i = 0; i < outerSequence.getItemCount(); ++i) {
                            outerNodeSet.add(outerSequence.itemAt(i));
                        }
                    } else {
                        outerNodeSet = outerSequence.toNodeSet();
                    }
                    if (outerSequence instanceof VirtualNodeSet) {
                        ((VirtualNodeSet)outerSequence).realize();
                    }
                    NodeSet ancestors = contextSet.selectAncestorDescendant(outerNodeSet, 0, true, this.getExpressionId());
                    if (contextSet.getDocumentSet().intersection(outerNodeSet.getDocumentSet()).getLength() == 0) {
                        LOG.info((Object)"contextSet and outerNodeSet don't share any document");
                    }
                    ExtArrayNodeSet temp = new ExtArrayNodeSet(100);
                    SequenceIterator i = ancestors.iterate();
                    while (i.hasNext()) {
                        NodeProxy p = (NodeProxy)i.nextItem();
                        temp.reset();
                        for (ContextItem contextNode = p.getContext(); contextNode != null; contextNode = contextNode.getNextDirect()) {
                            if (contextNode.getContextId() != this.getExpressionId()) continue;
                            temp.add(contextNode.getNode());
                        }
                        temp.sortInDocumentOrder();
                        SequenceIterator j = innerSeq.iterate();
                        while (j.hasNext()) {
                            NumericValue v = (NumericValue)j.nextItem();
                            if (v.hasFractionalPart() || v.isZero() || (p = temp.get(v.getInt() - 1)) == null) continue;
                            result.add((Item)p);
                        }
                    }
                    break;
                }
                default: {
                    SequenceIterator i = outerSequence.iterate();
                    while (i.hasNext()) {
                        NodeSet temp;
                        NodeProxy p = (NodeProxy)i.nextItem();
                        boolean reverseAxis = true;
                        switch (mode) {
                            case 0: {
                                temp = contextSet.selectAncestors(p, false, -2);
                                break;
                            }
                            case 1: {
                                temp = contextSet.selectAncestors(p, true, -2);
                                break;
                            }
                            case 2: {
                                temp = p.getParents(-1);
                                break;
                            }
                            case 3: {
                                temp = contextSet.selectPreceding(p);
                                break;
                            }
                            case 4: {
                                temp = contextSet.selectPrecedingSiblings(p, -2);
                                break;
                            }
                            case 10: {
                                temp = contextSet.selectFollowingSiblings(p, -2);
                                reverseAxis = false;
                                break;
                            }
                            case 9: {
                                temp = contextSet.selectFollowing(p);
                                reverseAxis = false;
                                break;
                            }
                            case 12: {
                                temp = p;
                                reverseAxis = false;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Tested unknown axis");
                            }
                        }
                        if (temp.isEmpty()) continue;
                        SequenceIterator j = innerSeq.iterate();
                        while (j.hasNext()) {
                            int pos;
                            NumericValue v = (NumericValue)j.nextItem();
                            if (v.hasFractionalPart() || v.isZero() || (pos = reverseAxis ? temp.getItemCount() - v.getInt() : v.getInt() - 1) < 0 || pos >= temp.getItemCount()) continue;
                            NodeProxy t = (NodeProxy)temp.itemAt(pos);
                            t.clearContext(-2);
                            for (ContextItem ctx = t.getContext(); ctx != null; ctx = ctx.getNextDirect()) {
                                if (ctx.getContextId() == this.outerContextId) {
                                    if (!ctx.getNode().getNodeId().equals(p.getNodeId())) continue;
                                    t.addContextNode(this.outerContextId, ctx.getNode());
                                    continue;
                                }
                                t.addContextNode(ctx.getContextId(), ctx.getNode());
                            }
                            result.add((Item)t);
                        }
                    }
                    break block0;
                }
            }
            return result;
        }
        TreeSet<NumericValue> set = new TreeSet<NumericValue>();
        ValueSequence result = new ValueSequence();
        SequenceIterator i = innerSeq.iterate();
        while (i.hasNext()) {
            int pos;
            NumericValue v = (NumericValue)i.nextItem();
            if (v.hasFractionalPart() || v.isZero() || (pos = v.getInt()) <= 0 || pos > contextSequence.getItemCount() || set.contains(v)) continue;
            result.add(contextSequence.itemAt(pos - 1));
            set.add(v);
        }
        return result;
    }

    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        if (this.getLength() > 0) {
            this.getExpression(0).setContextDocSet(contextSet);
        }
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        if (!postOptimization) {
            this.cached = null;
        }
    }

    public Expression getParent() {
        return this.parent;
    }

    public void accept(ExpressionVisitor visitor) {
        visitor.visitPredicate(this);
    }

    public void dump(ExpressionDumper dumper) {
        dumper.display("[");
        super.dump(dumper);
        dumper.display("]");
    }

    public String toString() {
        return "[" + super.toString() + "]";
    }
}

